/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.util;

import cf.terminator.laggoggles.packet.ObjectData;
import cf.terminator.laggoggles.profiler.ProfileResult;
import cf.terminator.laggoggles.server.RequestDataHandler;
import cf.terminator.laggoggles.server.ServerConfig;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Perms {
    public static final double MAX_RANGE_FOR_PLAYERS_HORIZONTAL_SQ = ServerConfig.NON_OPS_MAX_HORIZONTAL_RANGE * ServerConfig.NON_OPS_MAX_HORIZONTAL_RANGE;
    public static final double MAX_RANGE_FOR_PLAYERS_VERTICAL_SQ = ServerConfig.NON_OPS_MAX_VERTICAL_RANGE * ServerConfig.NON_OPS_MAX_HORIZONTAL_RANGE;

    public static Permission getPermission(EntityPlayer p) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_187452_a(p.func_146103_bH()) > 0 || !FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S()) {
            return Permission.FULL;
        }
        return ServerConfig.NON_OP_PERMISSION_LEVEL;
    }

    public static boolean hasPermission(EntityPlayer player, Permission permission) {
        return Perms.getPermission(player).ordinal() >= permission.ordinal();
    }

    public static ArrayList<EntityPlayerMP> getLagGogglesUsers() {
        ArrayList<EntityPlayerMP> list = new ArrayList<EntityPlayerMP>();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return list;
        }
        for (UUID uuid : RequestDataHandler.playersWithLagGoggles) {
            Entity entity = server.func_175576_a(uuid);
            if (!(entity instanceof EntityPlayerMP)) continue;
            list.add((EntityPlayerMP)entity);
        }
        return list;
    }

    public static ProfileResult getResultFor(EntityPlayerMP player, ProfileResult result) {
        Permission permission = Perms.getPermission((EntityPlayer)player);
        if (permission == Permission.NONE) {
            return ProfileResult.EMPTY_RESULT;
        }
        if (permission == Permission.FULL) {
            return result;
        }
        ProfileResult trimmedResult = result.copyStatsOnly();
        for (ObjectData data : result.getData()) {
            if (!Perms.isInRange(data, player)) continue;
            trimmedResult.addData(data);
        }
        return trimmedResult;
    }

    public static boolean isInRange(ObjectData data, EntityPlayerMP player) {
        if (data.type == ObjectData.Type.EVENT_BUS_LISTENER) {
            return ServerConfig.ALLOW_NON_OPS_TO_SEE_EVENT_SUBSCRIBERS;
        }
        if ((Integer)data.getValue(ObjectData.Entry.WORLD_ID) != player.field_71093_bK) {
            return false;
        }
        switch (data.type) {
            case ENTITY: {
                Entity e;
                WorldServer world = DimensionManager.getWorld((int)((Integer)data.getValue(ObjectData.Entry.WORLD_ID)));
                if (world != null && (e = world.func_175733_a((UUID)data.getValue(ObjectData.Entry.ENTITY_UUID))) != null) {
                    return Perms.checkRange(player, e.field_70165_t, e.field_70163_u, e.field_70161_v);
                }
                return false;
            }
            case BLOCK: 
            case TILE_ENTITY: {
                return Perms.checkRange(player, (Integer)data.getValue(ObjectData.Entry.BLOCK_POS_X), (Integer)data.getValue(ObjectData.Entry.BLOCK_POS_Y), (Integer)data.getValue(ObjectData.Entry.BLOCK_POS_Z));
            }
        }
        return false;
    }

    public static boolean checkRange(EntityPlayerMP player, Integer x, Integer y, Integer z) {
        return Perms.checkRange(player, x.doubleValue(), y.doubleValue(), z.doubleValue());
    }

    public static boolean checkRange(EntityPlayerMP player, double x, double y, double z) {
        double xD = x - player.field_70165_t;
        double zD = z - player.field_70161_v;
        if (xD * xD + zD * zD > MAX_RANGE_FOR_PLAYERS_HORIZONTAL_SQ) {
            return false;
        }
        if (y > (double)ServerConfig.NON_OPS_WHITELIST_HEIGHT_ABOVE) {
            return true;
        }
        double yD = y - player.field_70163_u;
        return !(yD * yD > MAX_RANGE_FOR_PLAYERS_VERTICAL_SQ);
    }

    public static enum Permission {
        NONE,
        GET,
        START,
        FULL;

    }
}

