/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common;

import com.nekokittygames.mffs.common.Functions;
import com.nekokittygames.mffs.common.Linkgrid;
import com.nekokittygames.mffs.common.SecurityRight;
import com.nekokittygames.mffs.common.tileentity.TileEntityAdvSecurityStation;
import com.nekokittygames.mffs.common.tileentity.TileEntityAreaDefenseStation;
import com.nekokittygames.mffs.common.tileentity.TileEntityCapacitor;
import com.nekokittygames.mffs.common.tileentity.TileEntityControlSystem;
import com.nekokittygames.mffs.common.tileentity.TileEntityExtractor;
import com.nekokittygames.mffs.common.tileentity.TileEntityProjector;
import com.nekokittygames.mffs.common.tileentity.TileEntitySecStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class SecurityHelper {
    public static boolean isAccessGranted(TileEntity tileEntity, EntityPlayer entityplayer, World world, SecurityRight right) {
        return SecurityHelper.isAccessGranted(tileEntity, entityplayer, world, right, false);
    }

    public static boolean isAccessGranted(TileEntity tileEntity, EntityPlayer entityplayer, World world, SecurityRight right, boolean suppresswarning) {
        if (tileEntity instanceof TileEntitySecStorage) {
            TileEntityAdvSecurityStation sec = ((TileEntitySecStorage)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                return sec.isAccessGranted(entityplayer.func_110124_au().toString(), right);
            }
            return !world.field_72995_K;
        }
        if (tileEntity instanceof TileEntityControlSystem) {
            TileEntityAdvSecurityStation sec = ((TileEntityControlSystem)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                return sec.isAccessGranted(entityplayer.func_110124_au().toString(), right);
            }
            return !world.field_72995_K;
        }
        if (tileEntity instanceof TileEntityAdvSecurityStation && !((TileEntityAdvSecurityStation)tileEntity).isAccessGranted(entityplayer.func_110124_au().toString(), right)) {
            if (!suppresswarning) {
                Functions.ChattoPlayer(entityplayer, "fieldSecurity.accessDenied", new Object[0]);
            }
            return false;
        }
        if (tileEntity instanceof TileEntityCapacitor) {
            TileEntityAdvSecurityStation sec = ((TileEntityCapacitor)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                if (sec.isAccessGranted(entityplayer.func_110124_au().toString(), right)) {
                    return true;
                }
                if (!suppresswarning) {
                    Functions.ChattoPlayer(entityplayer, "fieldSecurity.accessDenied", new Object[0]);
                }
                return false;
            }
            return true;
        }
        if (tileEntity instanceof TileEntityExtractor) {
            TileEntityAdvSecurityStation sec = ((TileEntityExtractor)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                if (sec.isAccessGranted(entityplayer.func_110124_au().toString(), right)) {
                    return true;
                }
                if (!suppresswarning) {
                    Functions.ChattoPlayer(entityplayer, "fieldSecurity.accessDenied", new Object[0]);
                }
                return false;
            }
            return true;
        }
        if (tileEntity instanceof TileEntityAreaDefenseStation) {
            TileEntityAdvSecurityStation sec = ((TileEntityAreaDefenseStation)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                if (sec.isAccessGranted(entityplayer.func_110124_au().toString(), right)) {
                    return true;
                }
                if (!suppresswarning) {
                    Functions.ChattoPlayer(entityplayer, "fieldSecurity.accessDenied", new Object[0]);
                }
                return false;
            }
            return true;
        }
        if (tileEntity instanceof TileEntityProjector) {
            switch (((TileEntityProjector)tileEntity).getaccesstyp()) {
                case 2: {
                    TileEntityAdvSecurityStation sec;
                    TileEntityCapacitor cap = Linkgrid.getWorldMap(world).getCapacitor().get(((TileEntityProjector)tileEntity).getPowerSourceID());
                    if (cap == null || (sec = cap.getLinkedSecurityStation()) == null) break;
                    if (sec.isAccessGranted(entityplayer.func_110124_au().toString(), right)) {
                        return true;
                    }
                    if (!suppresswarning) {
                        Functions.ChattoPlayer(entityplayer, "fieldSecurity.accessDenied", new Object[0]);
                    }
                    return false;
                }
                case 3: {
                    TileEntityAdvSecurityStation sec = ((TileEntityProjector)tileEntity).getLinkedSecurityStation();
                    if (sec == null) break;
                    if (sec.isAccessGranted(entityplayer.func_110124_au().toString(), right)) {
                        return true;
                    }
                    if (!suppresswarning) {
                        Functions.ChattoPlayer(entityplayer, "fieldSecurity.accessDenied", new Object[0]);
                    }
                    return false;
                }
            }
            return true;
        }
        return true;
    }
}

