/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.book.content;

import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.utils.ConstructUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.BookElement;
import slimeknights.mantle.client.gui.book.element.ElementImage;
import slimeknights.mantle.client.gui.book.element.ElementText;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.book.TinkerPage;
import slimeknights.tconstruct.library.book.content.ContentModifier;
import slimeknights.tconstruct.library.book.elements.ElementTinkerItem;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IModifierDisplay;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ContentArmorModifier
extends TinkerPage {
    public static final transient String ID = "armormodifier";
    private transient IModifier modifier;
    private transient List<Item> armor;
    public TextData[] text;
    public String[] effects;
    @SerializedName(value="armormodifier")
    public String modifierName;
    public String[] demoArmor = new String[]{ConstructUtils.getResource("chestplate").toString()};

    public ContentArmorModifier() {
    }

    public ContentArmorModifier(IModifier modifier) {
        this.modifier = modifier;
        this.modifierName = modifier.getIdentifier();
    }

    public void load() {
        if (this.modifierName == null) {
            this.modifierName = this.parent.name;
        }
        if (this.modifier == null) {
            this.modifier = TinkerRegistry.getModifier((String)this.modifierName);
        }
        if (this.armor == null) {
            this.armor = Lists.newArrayList();
            for (String entry : this.demoArmor) {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(entry));
                if (item == null) continue;
                this.armor.add(item);
            }
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        ImageData img;
        if (this.modifier == null) {
            TinkerModifiers.log.error("Modifier " + this.modifierName + " not found");
            return;
        }
        int color = 0xDDDDDD;
        int inCount = 1;
        ItemStack[][] inputItems = null;
        if (this.modifier instanceof IModifierDisplay) {
            int i;
            IModifierDisplay modifierDisplay = (IModifierDisplay)this.modifier;
            color = modifierDisplay.getColor();
            List inputList = modifierDisplay.getItems();
            inputItems = new ItemStack[5][];
            for (i = 0; i < 5; ++i) {
                inputItems[i] = new ItemStack[inputList.size()];
                for (int j = 0; j < inputItems[i].length; ++j) {
                    inputItems[i][j] = ItemStack.field_190927_a;
                }
            }
            for (i = 0; i < inputList.size(); ++i) {
                ArrayList inputs = new ArrayList((Collection)inputList.get(i));
                if (inputs.size() > inCount) {
                    inCount = inputs.size();
                }
                for (int j = 0; j < inputs.size() && j < 5; ++j) {
                    ItemStack stack = (ItemStack)inputs.get(j);
                    if (!stack.func_190926_b() && stack.func_77960_j() == Short.MAX_VALUE) {
                        stack = stack.func_77946_l();
                        stack.func_77964_b(0);
                    }
                    inputItems[j][i] = stack;
                }
            }
        }
        this.addTitle(list, CustomFontColor.encodeColor((int)color) + this.modifier.getLocalizedName(), true);
        int h = GuiBook.PAGE_WIDTH / 3 - 10;
        list.add((BookElement)new ElementText(10, 20, GuiBook.PAGE_WIDTH - 20, h, this.text));
        if (this.effects.length > 0) {
            TextData head = new TextData(this.parent.translate("modifier.effect"));
            head.underlined = true;
            list.add((BookElement)new ElementText(10, 20 + h, GuiBook.PAGE_WIDTH / 2 - 5, GuiBook.PAGE_HEIGHT - h - 20, new TextData[]{head}));
            ArrayList effectData = Lists.newArrayList();
            for (String e : this.effects) {
                effectData.add(new TextData("\u25cf "));
                effectData.add(new TextData(e));
                effectData.add(new TextData("\n"));
            }
            list.add((BookElement)new ElementText(10, 30 + h, GuiBook.PAGE_WIDTH / 2 + 5, GuiBook.PAGE_HEIGHT - h - 20, (Collection)effectData));
        }
        switch (inCount) {
            case 1: {
                img = ContentModifier.IMG_SLOT_1;
                break;
            }
            case 2: {
                img = ContentModifier.IMG_SLOT_2;
                break;
            }
            case 3: {
                img = ContentModifier.IMG_SLOT_3;
                break;
            }
            default: {
                img = ContentModifier.IMG_SLOT_5;
            }
        }
        int imgX = GuiBook.PAGE_WIDTH / 2 + 20;
        int imgY = GuiBook.PAGE_HEIGHT / 2 + 30;
        imgX = imgX + 29 - img.width / 2;
        imgY = imgY + 20 - img.height / 2;
        int[] slotX = new int[]{3, 21, 39, 12, 30};
        int[] slotY = new int[]{3, 3, 3, 22, 22};
        list.add((BookElement)new ElementImage(imgX + (img.width - ContentModifier.IMG_TABLE.width) / 2, imgY - 24, -1, -1, ContentModifier.IMG_TABLE));
        list.add((BookElement)new ElementImage(imgX, imgY, -1, -1, img, book.appearance.slotColor));
        ItemStackList demo = this.getDemoArmor(inputItems);
        ElementTinkerItem toolItem = new ElementTinkerItem(imgX + (img.width - 16) / 2, imgY - 24, 1.0f, (Collection)demo);
        toolItem.noTooltip = true;
        list.add((BookElement)toolItem);
        list.add((BookElement)new ElementImage(imgX + (img.width - 22) / 2, imgY - 27, -1, -1, ContentModifier.IMG_SLOT_1, 0xFFFFFF));
        if (inputItems != null) {
            for (int i = 0; i < inCount && i < 5; ++i) {
                list.add((BookElement)new ElementTinkerItem(imgX + slotX[i], imgY + slotY[i], 1.0f, inputItems[i]));
            }
        }
    }

    protected ItemStackList getDemoArmor(ItemStack[][] inputItems) {
        ItemStackList demo = ItemStackList.withSize((int)this.armor.size());
        for (int i = 0; i < this.armor.size(); ++i) {
            if (this.armor.get(i) instanceof ArmorCore) {
                ArmorCore core = (ArmorCore)this.armor.get(i);
                Object mats = ImmutableList.of((Object)TinkerMaterials.wood, (Object)TinkerMaterials.cobalt, (Object)TinkerMaterials.ardite, (Object)TinkerMaterials.manyullyn);
                mats = mats.subList(0, core.getRequiredComponents().size());
                demo.set(i, (Object)((ArmorCore)this.armor.get(i)).buildItemForRendering((List<Material>)mats));
            } else if (this.armor != null) {
                demo.set(i, (Object)new ItemStack(this.armor.get(i)));
            }
            if (((ItemStack)demo.get(i)).func_190926_b()) continue;
            this.modifier.apply((ItemStack)demo.get(i));
        }
        return demo;
    }
}

