/*
 * Decompiled with CFR 0.152.
 */
package thaumicperiphery.proxy;

import java.io.File;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import teamroots.embers.RegistryManager;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IThaumcraftRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.common.config.ConfigItems;
import thaumicperiphery.Config;
import thaumicperiphery.ModContent;
import thaumicperiphery.ThaumicPeriphery;
import thaumicperiphery.compat.MysticalMechanicsCompat;
import vazkii.botania.common.item.ModItems;

public class CommonProxy {
    public static Configuration config;

    public void preInit(FMLPreInitializationEvent event) {
        File directory = event.getModConfigurationDirectory();
        config = new Configuration(new File(directory.getPath(), "thaumic_periphery.cfg"));
        Config.readConfig();
    }

    public void init(FMLInitializationEvent event) {
        ResearchCategories.registerCategory((String)"PERIPHERY", (String)"UNLOCKAUROMANCY", (AspectList)new AspectList(), (ResourceLocation)new ResourceLocation("thaumcraft", "textures/misc/vortex.png"), (ResourceLocation)new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_2.jpg"), (ResourceLocation)new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_over.png"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumicperiphery", "research/periphery"));
        if (Config.emberCaster) {
            ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumicperiphery", "research/ember_caster"));
        }
        if (Config.manaCaster) {
            ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumicperiphery", "research/mana_caster"));
        }
        if (ThaumicPeriphery.mysticalMechanicsLoaded) {
            MysticalMechanicsCompat.init();
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (config.hasChanged()) {
            config.save();
        }
        if (Config.copperBrassRecipe) {
            this.replaceBrassRecipe();
        }
        this.initResearch();
    }

    protected void initResearch() {
        ResearchCategory periphery = ResearchCategories.getResearchCategory((String)"PERIPHERY");
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicperiphery", "pauldron_repulsion"), (InfusionRecipe)new InfusionRecipe("PAULDRONREPULSION", (Object)new ItemStack(ModContent.pauldron_repulsion), 1, new AspectList().add(Aspect.AIR, 50).add(Aspect.MOTION, 50).add(Aspect.PROTECT, 10), (Object)new ItemStack(ModContent.pauldron), new Object[]{new ItemStack(BlocksTC.pavingStoneBarrier), ConfigItems.AIR_CRYSTAL}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicperiphery", "malignant_heart"), (InfusionRecipe)new InfusionRecipe("MALIGNANTHEART", (Object)new ItemStack(ModContent.malignant_heart), 6, new AspectList().add(Aspect.AVERSION, 50).add(Aspect.DEATH, 50).add(Aspect.UNDEAD, 25).add(Aspect.FLUX, 15).add(Aspect.ENTROPY, 10), (Object)new ItemStack(BlocksTC.fleshBlock), new Object[]{new ItemStack(ItemsTC.brain), new ItemStack(Items.field_151075_bm), new ItemStack(ItemsTC.tallow), new ItemStack(Items.field_151078_bh), new ItemStack(ItemsTC.tallow), new ItemStack(Items.field_151073_bk)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicperiphery", "magic_quiver"), (InfusionRecipe)new InfusionRecipe("MAGICQUIVER", (Object)new ItemStack(ModContent.magic_quiver), 4, new AspectList().add(Aspect.VOID, 100).add(Aspect.ORDER, 25).add(Aspect.DESIRE, 25).add(Aspect.MAGIC, 15).add(Aspect.AURA, 15), (Object)new ItemStack(ItemsTC.baubles, 1, 2), new Object[]{new ItemStack(ItemsTC.visResonator), new ItemStack(Items.field_151116_aA), new ItemStack(ItemsTC.fabric), new ItemStack(Items.field_151032_g), new ItemStack(ItemsTC.fabric), new ItemStack(Items.field_151116_aA)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicperiphery", "vis_phylactery"), (InfusionRecipe)new InfusionRecipe("VISPHYLACTERY", (Object)new ItemStack(ModContent.vis_phylactery), 6, new AspectList().add(Aspect.TRAP, 50).add(Aspect.VOID, 25).add(Aspect.DESIRE, 25), (Object)new ItemStack(ItemsTC.amuletVis, 1, 1), new Object[]{new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.amber), new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(ItemsTC.amber)}));
        if (Config.emberCaster) {
            ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicperiphery", "caster_ember"), (InfusionRecipe)new InfusionRecipe("CASTEREMBER", (Object)new ItemStack(ModContent.caster_ember), 6, new AspectList().add(Aspect.FIRE, 50).add(Aspect.MAGIC, 15).add(Aspect.EXCHANGE, 25).add(Aspect.MECHANISM, 25).add(Aspect.ENERGY, 50), (Object)new ItemStack(RegistryManager.wildfire_core), new Object[]{new ItemStack(RegistryManager.shard_ember), "ingotDawnstone", "plateIron", new ItemStack(ItemsTC.mechanismComplex), "ingotCopper", new ItemStack(ItemsTC.morphicResonator), "plateIron", "ingotDawnstone"}));
        }
        if (Config.manaCaster) {
            ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicperiphery", "caster_elementium"), (InfusionRecipe)new InfusionRecipe("CASTERELEMENTIUM", (Object)new ItemStack(ModContent.caster_elementium), 6, new AspectList().add(Aspect.PLANT, 50).add(Aspect.MAGIC, 15).add(Aspect.EXCHANGE, 25).add(Aspect.ALCHEMY, 25).add(Aspect.ENERGY, 50), (Object)new ItemStack(ModItems.rune, 1, 8), new Object[]{new ItemStack(ItemsTC.morphicResonator), new ItemStack(ModItems.manaResource, 1, 7), "leather", new ItemStack(ModItems.manaResource, 1, 23), new ItemStack(ModItems.manaResource, 1, 22), new ItemStack(ItemsTC.salisMundus), "leather", new ItemStack(ModItems.manaResource, 1, 7)}));
        }
    }

    protected void replaceBrassRecipe() {
        IThaumcraftRecipe r = (IThaumcraftRecipe)ThaumcraftApi.getCraftingRecipes().get(new ResourceLocation("thaumcraft", "brassingot"));
        if (r != null && r instanceof CrucibleRecipe && OreDictionary.doesOreNameExist((String)"ingotCopper") && OreDictionary.getOres((String)"ingotCopper", (boolean)false).size() > 0) {
            CrucibleRecipe recipe = (CrucibleRecipe)r;
            recipe.setCatalyst((Ingredient)new OreIngredient("ingotCopper"));
        }
    }
}

