/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.sql;

import com.erigitic.main.TotalEconomy;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.sql.SqlService;

public class SqlManager {
    private Logger logger;
    public DataSource dataSource;
    private SqlService sql;

    public SqlManager(TotalEconomy totalEconomy, Logger logger) {
        this.logger = logger;
        try {
            this.dataSource = this.getDataSource("jdbc:" + totalEconomy.getDatabaseUrl() + "?user=" + totalEconomy.getDatabaseUser() + "&password=" + totalEconomy.getDatabasePassword());
        }
        catch (SQLException e) {
            logger.warn("Error getting data source!");
        }
        catch (UncheckedExecutionException e) {
            logger.warn("Error connecting to database! Check the config and make sure the database credentials are correct!");
        }
    }

    public DataSource getDataSource(String jdbcUrl) throws SQLException {
        if (this.sql == null) {
            this.sql = (SqlService)Sponge.getServiceManager().provide(SqlService.class).get();
        }
        return this.sql.getDataSource(jdbcUrl);
    }

    public boolean createTable(String tableName, String cols) {
        try {
            Connection conn = this.dataSource.getConnection();
            boolean result = conn.prepareStatement("CREATE TABLE IF NOT EXISTS " + tableName + " (" + cols + ")").execute();
            conn.close();
            return result;
        }
        catch (SQLException e) {
            this.logger.warn("[TE] An error occurred while creating a table!");
            e.printStackTrace();
            return false;
        }
    }
}

