/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicterminal.init;

import appeng.api.config.Upgrades;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartModels;
import ftblag.thaumicterminal.ThaumicTerminal;
import ftblag.thaumicterminal.init.ModItems;
import ftblag.thaumicterminal.item.ItemPart;
import ftblag.thaumicterminal.part.IPartHasCustModel;
import ftblag.thaumicterminal.part.PartArcaneTerminal;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class ModParts
extends Enum<ModParts> {
    public static final /* enum */ ModParts ARCANE_TERMINAL = new ModParts("arcane_terminal", PartArcaneTerminal.class);
    private String unlocalizedName;
    private ResourceLocation partItemLocation;
    private Class<? extends IPart> partClass;
    private Map<Upgrades, Integer> upgrades = new HashMap<Upgrades, Integer>();
    private static final /* synthetic */ ModParts[] $VALUES;

    public static ModParts[] values() {
        return (ModParts[])$VALUES.clone();
    }

    public static ModParts valueOf(String name) {
        return Enum.valueOf(ModParts.class, name);
    }

    private ModParts(String _unlocalizedName, Class<? extends IPart> _partClass) {
        this.unlocalizedName = "thaumicterminal.part." + _unlocalizedName;
        this.partClass = _partClass;
        this.partItemLocation = new ResourceLocation("thaumicterminal", "parts/" + _unlocalizedName);
    }

    private ModParts(String _unlocalizedName, Class<? extends IPart> _partClass, Pair<Upgrades, Integer>[] _upgrades) {
        this(_unlocalizedName, _partClass);
        for (Pair<Upgrades, Integer> pair : _upgrades) {
            this.upgrades.put((Upgrades)pair.getKey(), (Integer)pair.getValue());
        }
    }

    private static Pair<Upgrades, Integer> generatePair(Upgrades _upgrade, int max) {
        return new MutablePair((Object)_upgrade, (Object)max);
    }

    public static ModParts getPart(Class<? extends IPart> partClass) {
        for (ModParts part : ModParts.values()) {
            if (part.getPartClass() != partClass) continue;
            return part;
        }
        return null;
    }

    public static ModParts getPart(ItemStack is) {
        assert (is.func_77973_b() == ModItems.getInstance(ItemPart.class));
        if (is.func_77960_j() < ModParts.values().length && is.func_77960_j() >= 0) {
            return ModParts.values()[is.func_77960_j()];
        }
        ThaumicTerminal.logger.error("TTItemPart meta is wrong!");
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerPartModels(IPartModels modelsRegistry) {
        for (ModParts type : ModParts.values()) {
            try {
                IPart part;
                ItemStack partStack = ItemPart.itemStackMap.get((Object)type);
                if (partStack.func_190926_b() || (part = ItemPart.INSTANCE.createPartFromItemStack(partStack)) == null || !(part instanceof IPartHasCustModel)) continue;
                modelsRegistry.registerModels(((IPartHasCustModel)part).getModelsToRegister());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Class<? extends IPart> getPartClass() {
        return this.partClass;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public ResourceLocation getPartItemLocation() {
        return this.partItemLocation;
    }

    public Map<Upgrades, Integer> getUpgrades() {
        return this.upgrades;
    }

    public IPart newInstance(ItemStack partStack) {
        try {
            IPart part = this.partClass.getConstructor(ItemStack.class).newInstance(partStack);
            return part;
        }
        catch (Exception e) {
            ThaumicTerminal.logger.fatal("Could not instantiate part", (Throwable)e);
            return null;
        }
    }

    public ItemStack getStack() {
        return new ItemStack((Item)ItemPart.INSTANCE, 1, this.ordinal());
    }

    static {
        $VALUES = new ModParts[]{ARCANE_TERMINAL};
    }
}

