/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder.slot;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.gui.GuiUtil;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.elements.ConfigSlotElement;
import reborncore.client.gui.builder.slot.elements.ElementBase;
import reborncore.client.gui.builder.slot.elements.SlotType;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.packet.PacketConfigSave;
import reborncore.common.tile.TileLegacyMachineBase;

public class GuiSlotConfiguration {
    static HashMap<Integer, ConfigSlotElement> slotElementMap = new HashMap();
    public static int selectedSlot = 0;

    public static void reset() {
        selectedSlot = -1;
    }

    public static void init(GuiBase guiBase) {
        GuiSlotConfiguration.reset();
        slotElementMap.clear();
        BuiltContainer container = guiBase.container;
        for (Slot slot : container.field_75151_b) {
            if (guiBase.tile != slot.field_75224_c) continue;
            ConfigSlotElement slotElement = new ConfigSlotElement(guiBase.getMachine(), slot.getSlotIndex(), SlotType.NORMAL, slot.field_75223_e - guiBase.field_147003_i + 50, slot.field_75221_f - guiBase.field_147009_r - 25, guiBase);
            slotElementMap.put(slot.getSlotIndex(), slotElement);
        }
    }

    public static void draw(GuiBase guiBase, int mouseX, int mouseY) {
        BuiltContainer container = guiBase.container;
        for (Slot slot : container.field_75151_b) {
            if (guiBase.tile != slot.field_75224_c) continue;
            GlStateManager.func_179124_c((float)255.0f, (float)0.0f, (float)0.0f);
            Color color = new Color(255, 0, 0, 128);
            GuiUtil.drawGradientRect(slot.field_75223_e - 1, slot.field_75221_f - 1, 18, 18, color.getRGB(), color.getRGB());
            GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        }
        if (selectedSlot != -1) {
            slotElementMap.get(selectedSlot).draw(guiBase);
        }
    }

    public static List<ConfigSlotElement> getVisibleElements() {
        if (selectedSlot == -1) {
            return Collections.emptyList();
        }
        return slotElementMap.values().stream().filter(configSlotElement -> configSlotElement.getId() == selectedSlot).collect(Collectors.toList());
    }

    @SubscribeEvent
    public static void keyboardEvent(GuiScreenEvent.KeyboardInputEvent event) {
        if (!GuiSlotConfiguration.getVisibleElements().isEmpty() && Keyboard.getEventKey() == 1) {
            selectedSlot = -1;
            event.setCanceled(true);
        }
    }

    public static void copyToClipboard() {
        TileLegacyMachineBase machine = GuiSlotConfiguration.getMachine();
        if (machine == null || machine.slotConfiguration == null) {
            return;
        }
        String json = machine.slotConfiguration.toJson(machine.getClass().getCanonicalName());
        GuiScreen.func_146275_d((String)json);
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Slot configuration copyied to clipboard"));
    }

    public static void pasteFromClipboard() {
        TileLegacyMachineBase machine = GuiSlotConfiguration.getMachine();
        if (machine == null || machine.slotConfiguration == null) {
            return;
        }
        String json = GuiScreen.func_146277_j();
        try {
            machine.slotConfiguration.readJson(json, machine.getClass().getCanonicalName());
            NetworkManager.sendToServer(new PacketConfigSave(machine.func_174877_v(), machine.slotConfiguration));
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Slot configuration loaded from clipboard"));
        }
        catch (UnsupportedOperationException e) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
        }
    }

    @Nullable
    private static TileLegacyMachineBase getMachine() {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiBase)) {
            return null;
        }
        GuiBase base = (GuiBase)Minecraft.func_71410_x().field_71462_r;
        if (!(base.tile instanceof TileLegacyMachineBase)) {
            return null;
        }
        TileLegacyMachineBase machineBase = (TileLegacyMachineBase)base.tile;
        return machineBase;
    }

    public static boolean mouseClicked(int mouseX, int mouseY, int mouseButton, GuiBase guiBase) throws IOException {
        if (mouseButton == 0) {
            block0: for (ConfigSlotElement configSlotElement : GuiSlotConfiguration.getVisibleElements()) {
                for (ElementBase element : configSlotElement.elements) {
                    if (element.isInRect(guiBase, element.x, element.y, element.getWidth(guiBase.getMachine()), element.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                        element.isPressing = true;
                        boolean action = element.onStartPress(guiBase.getMachine(), guiBase, mouseX, mouseY);
                        for (ElementBase elementBase : GuiSlotConfiguration.getVisibleElements()) {
                            if (elementBase == element) continue;
                            elementBase.isPressing = false;
                        }
                        if (!action) continue;
                        continue block0;
                    }
                    element.isPressing = false;
                }
            }
        }
        BuiltContainer container = guiBase.container;
        if (GuiSlotConfiguration.getVisibleElements().isEmpty()) {
            for (Slot slot : container.field_75151_b) {
                if (guiBase.tile != slot.field_75224_c || !guiBase.isPointInRect(slot.field_75223_e, slot.field_75221_f, 18, 18, mouseX, mouseY)) continue;
                selectedSlot = slot.getSlotIndex();
                return true;
            }
        }
        return !GuiSlotConfiguration.getVisibleElements().isEmpty();
    }

    public static void mouseClickMove(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick, GuiBase guiBase) {
        if (mouseButton == 0) {
            block0: for (ConfigSlotElement configSlotElement : GuiSlotConfiguration.getVisibleElements()) {
                for (ElementBase element : configSlotElement.elements) {
                    if (element.isInRect(guiBase, element.x, element.y, element.getWidth(guiBase.getMachine()), element.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                        element.isDragging = true;
                        boolean action = element.onDrag(guiBase.getMachine(), guiBase, mouseX, mouseY);
                        for (ElementBase elementBase : GuiSlotConfiguration.getVisibleElements()) {
                            if (elementBase == element) continue;
                            elementBase.isDragging = false;
                        }
                        if (!action) continue;
                        continue block0;
                    }
                    element.isDragging = false;
                }
            }
        }
    }

    public static boolean mouseReleased(int mouseX, int mouseY, int mouseButton, GuiBase guiBase) {
        boolean clicked = false;
        if (mouseButton == 0) {
            block0: for (ConfigSlotElement configSlotElement : GuiSlotConfiguration.getVisibleElements()) {
                if (configSlotElement.isInRect(guiBase, configSlotElement.x, configSlotElement.y, configSlotElement.getWidth(guiBase.getMachine()), configSlotElement.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                    clicked = true;
                }
                for (ElementBase element : Lists.reverse(configSlotElement.elements)) {
                    if (element.isInRect(guiBase, element.x, element.y, element.getWidth(guiBase.getMachine()), element.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                        element.isReleasing = true;
                        boolean action = element.onRelease(guiBase.getMachine(), guiBase, mouseX, mouseY);
                        for (ElementBase elementBase : GuiSlotConfiguration.getVisibleElements()) {
                            if (elementBase == element) continue;
                            elementBase.isReleasing = false;
                        }
                        if (!action) continue block0;
                        clicked = true;
                        continue block0;
                    }
                    element.isReleasing = false;
                }
            }
        }
        return clicked;
    }

    public static List<Rectangle> getExtraSpace(GuiBase guiBase) {
        if (GuiBase.slotConfigType != GuiBase.SlotConfigType.ITEMS || selectedSlot == -1) {
            return Collections.emptyList();
        }
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        ConfigSlotElement slotElement = slotElementMap.get(selectedSlot);
        if (slotElement == null || guiBase == null) {
            return Collections.emptyList();
        }
        list.add(new Rectangle(slotElement.adjustX(guiBase, slotElement.getX()) + guiBase.getGuiLeft() - 25, slotElement.adjustY(guiBase, 0) - 10, slotElement.getWidth() - 5, slotElement.getHeight() + 15));
        return list;
    }
}

