/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.power.ExternalPowerHandler;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.StringUtils;

public abstract class TilePowerAcceptor
extends TileLegacyMachineBase
implements IEnergyInterfaceTile,
IListInfoProvider {
    private EnumPowerTier tier;
    private double energy;
    public double extraPowerStoage;
    public double extraPowerInput;
    public int extraTeir;
    public double powerChange;
    public double powerLastTick;
    public boolean checkOverfill = true;
    private List<ExternalPowerHandler> powerManagers;

    public TilePowerAcceptor() {
        this.checkTeir();
        this.setupManagers();
    }

    @Deprecated
    public TilePowerAcceptor(EnumPowerTier tier) {
        this();
    }

    private void setupManagers() {
        TilePowerAcceptor tile = this;
        this.powerManagers = ExternalPowerSystems.externalPowerHandlerList.stream().map(externalPowerManager -> externalPowerManager.createPowerHandler(tile)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void checkTeir() {
        if (this.getBaseTier() == null) {
            this.tier = this.getMaxInput() == 0.0 ? EnumPowerTier.getTeir((int)this.getBaseMaxOutput()) : EnumPowerTier.getTeir((int)this.getBaseMaxInput());
        }
    }

    public void setExtraPowerStoage(double extraPowerStoage) {
        this.extraPowerStoage = extraPowerStoage;
    }

    public double getFreeSpace() {
        return this.getMaxPower() - this.getEnergy();
    }

    public void charge(int slot) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        double chargeEnergy = Math.min(this.getFreeSpace(), this.getMaxInput());
        if (chargeEnergy <= 0.0) {
            return;
        }
        ItemStack batteryStack = this.func_70301_a(slot);
        if (batteryStack.func_190926_b()) {
            return;
        }
        if (ExternalPowerSystems.isPoweredItem(batteryStack)) {
            ExternalPowerSystems.dischargeItem(this, batteryStack);
        }
    }

    public int getEnergyScaled(int scale) {
        return (int)(this.getEnergy() * (double)scale / this.getMaxPower());
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tag) {
        NBTTagCompound data = tag.func_74775_l("TilePowerAcceptor");
        if (this.shouldHanldeEnergyNBT()) {
            this.setEnergy(data.func_74769_h("energy"));
        }
    }

    public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tag) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energy);
        tag.func_74782_a("TilePowerAcceptor", (NBTBase)data);
        return tag;
    }

    public boolean shouldHanldeEnergyNBT() {
        return true;
    }

    public boolean handleTierWithPower() {
        return true;
    }

    public double getPowerChange() {
        return this.powerChange;
    }

    public void setPowerChange(double powerChange) {
        this.powerChange = powerChange;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.powerManagers.forEach(ExternalPowerHandler::tick);
        this.powerChange = this.getEnergy() - this.powerLastTick;
        this.powerLastTick = this.getEnergy();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound data = tag.func_74775_l("TilePowerAcceptor");
        if (this.shouldHanldeEnergyNBT()) {
            this.setEnergy(data.func_74769_h("energy"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.getEnergy());
        tag.func_74782_a("TilePowerAcceptor", (NBTBase)data);
        return tag;
    }

    @Override
    public void resetUpgrades() {
        super.resetUpgrades();
        this.extraPowerStoage = 0.0;
        this.extraTeir = 0;
        this.extraPowerInput = 0.0;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.powerManagers.stream().filter(Objects::nonNull).anyMatch(externalPowerHandler -> externalPowerHandler.hasCapability(capability, facing))) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        T externalCap = this.powerManagers.stream().filter(Objects::nonNull).map(externalPowerHandler -> externalPowerHandler.getCapability(capability, facing)).filter(Objects::nonNull).findFirst().orElse(null);
        if (externalCap != null) {
            return externalCap;
        }
        return super.getCapability(capability, facing);
    }

    public abstract double getBaseMaxPower();

    public abstract double getBaseMaxOutput();

    public abstract double getBaseMaxInput();

    @Deprecated
    public EnumPowerTier getBaseTier() {
        return null;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.powerManagers.forEach(ExternalPowerHandler::invalidate);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.powerManagers.forEach(ExternalPowerHandler::unload);
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public void setEnergy(double energy) {
        if (!this.checkOverfill) {
            this.energy = energy;
            return;
        }
        this.energy = Math.max(Math.min(energy, this.getMaxPower()), 0.0);
    }

    @Override
    public double addEnergy(double energy) {
        return this.addEnergy(energy, false);
    }

    @Override
    public double addEnergy(double energy, boolean simulate) {
        double energyReceived = Math.min(this.getMaxPower(), Math.min(this.getFreeSpace(), energy));
        if (!simulate) {
            this.setEnergy(this.getEnergy() + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public boolean canUseEnergy(double input) {
        return input <= this.energy;
    }

    @Override
    public double useEnergy(double energy) {
        return this.useEnergy(energy, false);
    }

    @Override
    public double useEnergy(double extract, boolean simulate) {
        if (extract > this.energy) {
            extract = this.energy;
        }
        if (!simulate) {
            this.setEnergy(this.energy - extract);
        }
        return extract;
    }

    @Override
    public boolean canAddEnergy(double energyIn) {
        return this.getEnergy() + energyIn <= this.getMaxPower();
    }

    @Override
    public double getMaxPower() {
        return this.getBaseMaxPower() + this.extraPowerStoage;
    }

    @Override
    public double getMaxOutput() {
        double maxOutput = 0.0;
        maxOutput = this.extraTeir > 0 ? (double)this.getTier().getMaxOutput() : this.getBaseMaxOutput();
        return maxOutput;
    }

    @Override
    public double getMaxInput() {
        double maxInput = 0.0;
        maxInput = this.extraTeir > 0 ? (double)this.getTier().getMaxInput() : this.getBaseMaxInput();
        return maxInput + this.extraPowerInput;
    }

    public EnumPowerTier getPushingTier() {
        return this.getTier();
    }

    @Override
    public EnumPowerTier getTier() {
        EnumPowerTier baseTier = this.getBaseTier();
        if (baseTier == null) {
            if (this.tier == null) {
                this.checkTeir();
            }
            baseTier = this.tier;
        }
        if (this.extraTeir > 0) {
            for (EnumPowerTier tier : EnumPowerTier.values()) {
                if (tier.getIC2Tier() != baseTier.getIC2Tier() + this.extraTeir) continue;
                return tier;
            }
            return EnumPowerTier.INFINITE;
        }
        return baseTier;
    }

    @Override
    public void addInfo(List<String> info, boolean isRealTile) {
        info.add(TextFormatting.GRAY + StringUtils.t("reborncore.tooltip.energy.maxEnergy") + ": " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted(this.getMaxPower()));
        if (this.getMaxInput() != 0.0) {
            info.add(TextFormatting.GRAY + StringUtils.t("reborncore.tooltip.energy.inputRate") + ": " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted(this.getMaxInput()));
        }
        if (this.getMaxOutput() != 0.0) {
            info.add(TextFormatting.GRAY + StringUtils.t("reborncore.tooltip.energy.outputRate") + ": " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted(this.getMaxOutput()));
        }
        info.add(TextFormatting.GRAY + StringUtils.t("reborncore.tooltip.energy.tier") + ": " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase(this.getTier().toString()));
        if (isRealTile) {
            info.add(TextFormatting.GRAY + StringUtils.t("reborncore.tooltip.energy.change") + ": " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted(this.getPowerChange()) + "/t");
        }
    }

    @Deprecated
    public boolean canConnectEnergy(EnumFacing from) {
        return this.canAcceptEnergy(from) || this.canProvideEnergy(from);
    }

    @Deprecated
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.canAcceptEnergy(from)) {
            return 0;
        }
        int feReceived = (int)Math.min((double)(this.getMaxEnergyStored(from) - this.getEnergyStored(from)), Math.min(this.getMaxInput() * (double)RebornCoreConfig.euPerFU, (double)maxReceive));
        int euReceived = feReceived / RebornCoreConfig.euPerFU;
        feReceived = euReceived * RebornCoreConfig.euPerFU;
        if (!simulate) {
            this.setEnergy(this.getEnergy() + (double)euReceived);
        }
        return feReceived;
    }

    @Deprecated
    public int getEnergyStored(EnumFacing from) {
        return (int)this.getEnergy() * RebornCoreConfig.euPerFU;
    }

    @Deprecated
    public int getMaxEnergyStored(EnumFacing from) {
        return (int)this.getMaxPower() * RebornCoreConfig.euPerFU;
    }

    @Deprecated
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (!this.canProvideEnergy(from)) {
            return 0;
        }
        int euExtracted = Math.min(this.getEnergyStored(null), maxExtract / RebornCoreConfig.euPerFU);
        int feExtracted = euExtracted * RebornCoreConfig.euPerFU;
        if (!simulate) {
            this.setEnergy(this.getEnergy() - (double)euExtracted);
        }
        return feExtracted;
    }
}

