/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.serializer;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.ShopsData;
import com.google.common.reflect.TypeToken;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.service.economy.Currency;

public class CurrencySerializer
implements TypeSerializer<Currency> {
    public Currency deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        String val = value.getNode(new Object[]{"currency"}).getString();
        if (!ShopsData.hasMultipleCurrencies() || val == null || val.isEmpty()) {
            return null;
        }
        for (Currency cur : CarrotShop.getEcoService().getCurrencies()) {
            if (!val.equals(cur.getId())) continue;
            return cur;
        }
        return null;
    }

    public void serialize(TypeToken<?> type, Currency obj, ConfigurationNode value) throws ObjectMappingException {
        if (ShopsData.hasMultipleCurrencies() && obj != null) {
            value.getNode(new Object[]{"currency"}).setValue((Object)obj.getId());
        }
    }
}

