/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.Log;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.Storage;
import me.lucko.luckperms.api.Track;
import me.lucko.luckperms.api.User;
import me.lucko.luckperms.api.event.cause.CreationCause;
import me.lucko.luckperms.api.event.cause.DeletionCause;
import me.lucko.luckperms.common.api.ApiUtils;
import me.lucko.luckperms.common.api.delegates.model.ApiGroup;
import me.lucko.luckperms.common.api.delegates.model.ApiLog;
import me.lucko.luckperms.common.api.delegates.model.ApiTrack;
import me.lucko.luckperms.common.api.delegates.model.ApiUser;
import me.lucko.luckperms.common.bulkupdate.comparisons.Constraint;
import me.lucko.luckperms.common.bulkupdate.comparisons.StandardComparison;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiStorage
implements Storage {
    private static final Function<Throwable, Boolean> CONSUME_EXCEPTION = throwable -> {
        throwable.printStackTrace();
        return false;
    };
    private final LuckPermsPlugin plugin;
    private final me.lucko.luckperms.common.storage.Storage handle;

    private static Function<Throwable, Boolean> consumeExceptionToFalse() {
        return CONSUME_EXCEPTION;
    }

    private static <T> Function<Throwable, T> consumeExceptionToNull() {
        return throwable -> {
            throwable.printStackTrace();
            return null;
        };
    }

    public ApiStorage(LuckPermsPlugin plugin, me.lucko.luckperms.common.storage.Storage handle) {
        this.plugin = plugin;
        this.handle = handle;
    }

    @Override
    public @NonNull String getName() {
        return this.handle.getName();
    }

    @Override
    public boolean isAcceptingLogins() {
        return true;
    }

    @Override
    public @NonNull Executor getSyncExecutor() {
        return this.plugin.getBootstrap().getScheduler().sync();
    }

    @Override
    public @NonNull Executor getAsyncExecutor() {
        return this.plugin.getBootstrap().getScheduler().async();
    }

    @Override
    public @NonNull CompletableFuture<Boolean> logAction(@NonNull LogEntry entry) {
        Objects.requireNonNull(entry, "entry");
        return ((CompletableFuture)this.handle.logAction(entry).thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Log> getLog() {
        return ((CompletableFuture)this.handle.getLog().thenApply(ApiLog::new)).exceptionally(ApiStorage.consumeExceptionToNull());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> loadUser(@NonNull UUID uuid, String username) {
        Objects.requireNonNull(uuid, "uuid");
        username = ApiUtils.checkUsername(username);
        if (this.plugin.getUserManager().getIfLoaded(uuid) == null) {
            this.plugin.getUserManager().getHouseKeeper().registerApiUsage(uuid);
        }
        return ((CompletableFuture)this.handle.loadUser(uuid, username).thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> saveUser(@NonNull User user) {
        Objects.requireNonNull(user, "user");
        return ((CompletableFuture)this.handle.saveUser(ApiUser.cast(user)).thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Set<UUID>> getUniqueUsers() {
        return this.handle.getUniqueUsers().exceptionally(ApiStorage.consumeExceptionToNull());
    }

    @Override
    public @NonNull CompletableFuture<List<HeldPermission<UUID>>> getUsersWithPermission(@NonNull String permission) {
        Objects.requireNonNull(permission, "permission");
        return this.handle.getUsersWithPermission(Constraint.of(StandardComparison.EQUAL, permission)).exceptionally(ApiStorage.consumeExceptionToNull());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> createAndLoadGroup(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return ((CompletableFuture)this.handle.createAndLoadGroup(ApiUtils.checkName(name), CreationCause.API).thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> loadGroup(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return ((CompletableFuture)this.handle.loadGroup(ApiUtils.checkName(name)).thenApply(Optional::isPresent)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> loadAllGroups() {
        return ((CompletableFuture)this.handle.loadAllGroups().thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> saveGroup(@NonNull Group group) {
        Objects.requireNonNull(group, "group");
        return ((CompletableFuture)this.handle.saveGroup(ApiGroup.cast(group)).thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> deleteGroup(@NonNull Group group) {
        Objects.requireNonNull(group, "group");
        if (group.getName().equalsIgnoreCase("default")) {
            throw new IllegalArgumentException("Cannot delete the default group.");
        }
        return ((CompletableFuture)this.handle.deleteGroup(ApiGroup.cast(group), DeletionCause.API).thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<List<HeldPermission<String>>> getGroupsWithPermission(@NonNull String permission) {
        Objects.requireNonNull(permission, "permission");
        return this.handle.getGroupsWithPermission(Constraint.of(StandardComparison.EQUAL, permission)).exceptionally(ApiStorage.consumeExceptionToNull());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> createAndLoadTrack(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return ((CompletableFuture)this.handle.createAndLoadTrack(ApiUtils.checkName(name), CreationCause.API).thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> loadTrack(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return ((CompletableFuture)this.handle.loadTrack(ApiUtils.checkName(name)).thenApply(Optional::isPresent)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> loadAllTracks() {
        return ((CompletableFuture)this.handle.loadAllTracks().thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> saveTrack(@NonNull Track track) {
        Objects.requireNonNull(track, "track");
        return ((CompletableFuture)this.handle.saveTrack(ApiTrack.cast(track)).thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> deleteTrack(@NonNull Track track) {
        Objects.requireNonNull(track, "track");
        return ((CompletableFuture)this.handle.deleteTrack(ApiTrack.cast(track), DeletionCause.API).thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> saveUUIDData(@NonNull String username, @NonNull UUID uuid) {
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(uuid, "uuid");
        return ((CompletableFuture)this.handle.savePlayerData(uuid, ApiUtils.checkUsername(username)).thenApply(r -> true)).exceptionally(ApiStorage.consumeExceptionToFalse());
    }

    @Override
    public @NonNull CompletableFuture<UUID> getUUID(@NonNull String username) {
        Objects.requireNonNull(username, "username");
        return this.handle.getPlayerUuid(ApiUtils.checkUsername(username));
    }

    @Override
    public @NonNull CompletableFuture<String> getName(@NonNull UUID uuid) {
        Objects.requireNonNull(uuid, "uuid");
        return this.handle.getPlayerName(uuid);
    }
}

