/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.assignments;

import java.util.List;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.common.assignments.AssignmentExpression;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.LegacyNodeFactory;
import me.lucko.luckperms.common.utils.ImmutableCollectors;

public class AssignmentRule {
    private final AssignmentExpression hasTrueExpression;
    private final AssignmentExpression hasFalseExpression;
    private final AssignmentExpression lacksExpression;
    private final List<Node> toGive;
    private final List<Node> toTake;
    private final String setPrimaryGroup;

    public AssignmentRule(String hasTrueExpression, String hasFalseExpression, String lacksExpression, List<String> toGive, List<String> toTake, String setPrimaryGroup) {
        this.hasTrueExpression = AssignmentExpression.compile(hasTrueExpression);
        this.hasFalseExpression = AssignmentExpression.compile(hasFalseExpression);
        this.lacksExpression = AssignmentExpression.compile(lacksExpression);
        this.toGive = (List)toGive.stream().map(s -> LegacyNodeFactory.fromLegacyString(s, true)).collect(ImmutableCollectors.toList());
        this.toTake = (List)toTake.stream().map(s -> LegacyNodeFactory.fromLegacyString(s, true)).collect(ImmutableCollectors.toList());
        this.setPrimaryGroup = setPrimaryGroup;
    }

    public boolean apply(User user) {
        boolean b;
        if (this.hasTrueExpression != null) {
            try {
                b = this.hasTrueExpression.eval(user, Tristate.TRUE);
                if (!b) {
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.hasFalseExpression != null) {
            try {
                b = this.hasFalseExpression.eval(user, Tristate.FALSE);
                if (!b) {
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.lacksExpression != null) {
            try {
                b = this.lacksExpression.eval(user, Tristate.UNDEFINED);
                if (!b) {
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return false;
            }
        }
        for (Node n : this.toTake) {
            user.unsetPermission(n);
        }
        for (Node n : this.toGive) {
            user.setPermission(n);
        }
        if (this.setPrimaryGroup != null) {
            user.getPrimaryGroup().setStoredValue(this.setPrimaryGroup);
        }
        return true;
    }

    public AssignmentExpression getHasTrueExpression() {
        return this.hasTrueExpression;
    }

    public AssignmentExpression getHasFalseExpression() {
        return this.hasFalseExpression;
    }

    public AssignmentExpression getLacksExpression() {
        return this.lacksExpression;
    }

    public List<Node> getToGive() {
        return this.toGive;
    }

    public List<Node> getToTake() {
        return this.toTake;
    }

    public String getSetPrimaryGroup() {
        return this.setPrimaryGroup;
    }

    public String toString() {
        return "AssignmentRule(hasTrueExpression=" + this.getHasTrueExpression() + ", hasFalseExpression=" + this.getHasFalseExpression() + ", lacksExpression=" + this.getLacksExpression() + ", toGive=" + this.getToGive() + ", toTake=" + this.getToTake() + ", setPrimaryGroup=" + this.getSetPrimaryGroup() + ")";
    }
}

