/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class PreparedStatementBuilder {
    private final StringBuilder sb = new StringBuilder();
    private final List<String> variables = new ArrayList<String>();

    public PreparedStatementBuilder append(String s) {
        this.sb.append(s);
        return this;
    }

    public PreparedStatementBuilder variable(String variable) {
        this.variables.add(variable);
        return this;
    }

    public PreparedStatement build(Connection connection, Function<String, String> mapping) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(mapping.apply(this.sb.toString()));
        for (int i = 0; i < this.variables.size(); ++i) {
            String var = this.variables.get(i);
            statement.setString(i + 1, var);
        }
        return statement;
    }

    public String toReadableString() {
        String s = this.sb.toString();
        for (String var : this.variables) {
            s = s.replaceFirst("\\?", var);
        }
        return s;
    }
}

