/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.utils;

import java.util.Optional;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.messaging.InternalMessagingService;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;

public final class StorageAssistant {
    public static Group loadGroup(String target, Sender sender, LuckPermsPlugin plugin, boolean auditTemporary) {
        if (sender.isImport()) {
            Group group = (Group)plugin.getGroupManager().getIfLoaded(target);
            if (group == null) {
                Message.GROUP_NOT_FOUND.send(sender, target);
            }
            return group;
        }
        Group group = plugin.getStorage().loadGroup(target).join().orElse(null);
        if (group == null) {
            group = plugin.getGroupManager().getByDisplayName(target);
            if (group == null) {
                Message.GROUP_NOT_FOUND.send(sender, target);
                return null;
            }
            plugin.getStorage().loadGroup(group.getName()).join();
        }
        if (auditTemporary) {
            group.auditTemporaryPermissions();
        }
        return group;
    }

    public static Track loadTrack(String target, Sender sender, LuckPermsPlugin plugin) {
        Track track = sender.isImport() ? (Track)plugin.getTrackManager().getIfLoaded(target) : (Track)plugin.getStorage().loadTrack(target).join().orElse(null);
        if (track == null) {
            Message.TRACK_NOT_FOUND.send(sender, target);
            return null;
        }
        return track;
    }

    public static void save(User user, Sender sender, LuckPermsPlugin plugin) {
        if (sender.isImport()) {
            plugin.getStorage().saveUser(user).join();
            return;
        }
        try {
            plugin.getStorage().saveUser(user).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.USER_SAVE_ERROR.send(sender, user.getFormattedDisplayName());
            return;
        }
        Optional<InternalMessagingService> messagingService = plugin.getMessagingService();
        if (messagingService.isPresent() && plugin.getConfiguration().get(ConfigKeys.AUTO_PUSH_UPDATES).booleanValue()) {
            messagingService.get().pushUserUpdate(user);
        }
    }

    public static void save(Group group, Sender sender, LuckPermsPlugin plugin) {
        if (sender.isImport()) {
            plugin.getStorage().saveGroup(group);
            return;
        }
        try {
            plugin.getStorage().saveGroup(group).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.GROUP_SAVE_ERROR.send(sender, group.getFormattedDisplayName());
            return;
        }
        plugin.getGroupManager().invalidateAllGroupCaches();
        plugin.getUserManager().invalidateAllUserCaches();
        Optional<InternalMessagingService> messagingService = plugin.getMessagingService();
        if (messagingService.isPresent() && plugin.getConfiguration().get(ConfigKeys.AUTO_PUSH_UPDATES).booleanValue()) {
            messagingService.get().getUpdateBuffer().request();
        }
    }

    public static void save(Track track, Sender sender, LuckPermsPlugin plugin) {
        if (sender.isImport()) {
            plugin.getStorage().saveTrack(track);
            return;
        }
        try {
            plugin.getStorage().saveTrack(track).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.TRACK_SAVE_ERROR.send(sender, track.getName());
            return;
        }
        plugin.getGroupManager().invalidateAllGroupCaches();
        plugin.getUserManager().invalidateAllUserCaches();
        Optional<InternalMessagingService> messagingService = plugin.getMessagingService();
        if (messagingService.isPresent() && plugin.getConfiguration().get(ConfigKeys.AUTO_PUSH_UPDATES).booleanValue()) {
            messagingService.get().getUpdateBuffer().request();
        }
    }

    public static void save(PermissionHolder holder, Sender sender, LuckPermsPlugin plugin) {
        if (holder.getType().isUser()) {
            User user = (User)holder;
            StorageAssistant.save(user, sender, plugin);
        } else if (holder.getType().isGroup()) {
            Group group = (Group)holder;
            StorageAssistant.save(group, sender, plugin);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private StorageAssistant() {
    }
}

