/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.factory;

import java.util.Map;
import me.lucko.luckperms.api.ChatMetaType;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.node.factory.LegacyNodeFactory;
import me.lucko.luckperms.common.node.factory.NodeBuilder;

public final class NodeFactory {
    public static final String DEFAULT_GROUP_NAME = "default";

    public static Node.Builder builder(String s) {
        return new NodeBuilder(s);
    }

    public static Node.Builder buildGroupNode(String groupName) {
        return new NodeBuilder(NodeFactory.groupNode(groupName));
    }

    public static Node.Builder buildGroupNode(Group group) {
        return new NodeBuilder(NodeFactory.groupNode(group.getName()));
    }

    public static Node.Builder buildMetaNode(String key, String value) {
        return new NodeBuilder(NodeFactory.metaNode(key, value));
    }

    public static Node.Builder buildChatMetaNode(ChatMetaType type, int priority, String s) {
        return type == ChatMetaType.PREFIX ? NodeFactory.buildPrefixNode(priority, s) : NodeFactory.buildSuffixNode(priority, s);
    }

    public static Node.Builder buildPrefixNode(int priority, String prefix) {
        return new NodeBuilder(NodeFactory.prefixNode(priority, prefix));
    }

    public static Node.Builder buildSuffixNode(int priority, String suffix) {
        return new NodeBuilder(NodeFactory.suffixNode(priority, suffix));
    }

    public static Node.Builder buildWeightNode(int weight) {
        return new NodeBuilder(NodeFactory.weightNode(weight));
    }

    public static String groupNode(String groupName) {
        return "group." + groupName;
    }

    public static String chatMetaNode(ChatMetaType type, int priority, String value) {
        return type == ChatMetaType.PREFIX ? NodeFactory.prefixNode(priority, value) : NodeFactory.suffixNode(priority, value);
    }

    public static String prefixNode(int priority, String prefix) {
        return "prefix." + priority + "." + LegacyNodeFactory.escapeCharacters(prefix);
    }

    public static String suffixNode(int priority, String suffix) {
        return "suffix." + priority + "." + LegacyNodeFactory.escapeCharacters(suffix);
    }

    public static String metaNode(String key, String value) {
        return "meta." + LegacyNodeFactory.escapeCharacters(key) + "." + LegacyNodeFactory.escapeCharacters(value);
    }

    public static String weightNode(int weight) {
        return "weight." + weight;
    }

    public static Node make(String node) {
        return NodeFactory.builder(node).build();
    }

    public static Node make(String node, boolean value) {
        return NodeFactory.builder(node).setValue(value).build();
    }

    public static Node make(String node, boolean value, String server) {
        return NodeFactory.builder(node).setValue(value).setServer(server).build();
    }

    public static Node make(String node, boolean value, String server, String world) {
        return NodeFactory.builder(node).setValue(value).setServer(server).setWorld(world).build();
    }

    public static Node make(String node, String server) {
        return NodeFactory.builder(node).setServer(server).build();
    }

    public static Node make(String node, String server, String world) {
        return NodeFactory.builder(node).setServer(server).setWorld(world).build();
    }

    public static Node make(String node, boolean value, boolean temporary) {
        return NodeFactory.builder(node).setValue(value).setExpiry(temporary ? 10L : 0L).build();
    }

    public static Node make(String node, boolean value, String server, boolean temporary) {
        return NodeFactory.builder(node).setValue(value).setServer(server).setExpiry(temporary ? 10L : 0L).build();
    }

    public static Node make(String node, boolean value, String server, String world, boolean temporary) {
        return NodeFactory.builder(node).setValue(value).setServer(server).setWorld(world).setExpiry(temporary ? 10L : 0L).build();
    }

    public static Node make(String node, String server, boolean temporary) {
        return NodeFactory.builder(node).setServer(server).setExpiry(temporary ? 10L : 0L).build();
    }

    public static Node make(String node, String server, String world, boolean temporary) {
        return NodeFactory.builder(node).setServer(server).setWorld(world).setExpiry(temporary ? 10L : 0L).build();
    }

    public static Node make(String node, boolean value, long expireAt) {
        return NodeFactory.builder(node).setValue(value).setExpiry(expireAt).build();
    }

    public static Node make(String node, boolean value, String server, long expireAt) {
        return NodeFactory.builder(node).setValue(value).setServer(server).setExpiry(expireAt).build();
    }

    public static Node make(String node, boolean value, String server, String world, long expireAt) {
        return NodeFactory.builder(node).setValue(value).setServer(server).setWorld(world).setExpiry(expireAt).build();
    }

    public static Node make(Group group, long expireAt) {
        return NodeFactory.make(NodeFactory.groupNode(group.getName()), true, expireAt);
    }

    public static Node make(Group group, String server, long expireAt) {
        return NodeFactory.make(NodeFactory.groupNode(group.getName()), true, server, expireAt);
    }

    public static Node make(Group group, String server, String world, long expireAt) {
        return NodeFactory.make(NodeFactory.groupNode(group.getName()), true, server, world, expireAt);
    }

    public static Node make(Group group) {
        return NodeFactory.make(NodeFactory.groupNode(group.getName()));
    }

    public static Node make(Group group, boolean temporary) {
        return NodeFactory.make(NodeFactory.groupNode(group.getName()), temporary);
    }

    public static Node make(Group group, String server) {
        return NodeFactory.make(NodeFactory.groupNode(group.getName()), server);
    }

    public static Node make(Group group, String server, String world) {
        return NodeFactory.make(NodeFactory.groupNode(group.getName()), server, world);
    }

    public static Node make(Group group, String server, boolean temporary) {
        return NodeFactory.make(NodeFactory.groupNode(group.getName()), server, temporary);
    }

    public static Node make(Group group, String server, String world, boolean temporary) {
        return NodeFactory.make(NodeFactory.groupNode(group.getName()), server, world, temporary);
    }

    public static String nodeAsCommand(Node node, String id, HolderType type, boolean set, boolean explicitGlobalContext) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(type.toString()).append(" ").append(id).append(" ");
        if (node.isGroupNode()) {
            sb.append("parent ");
            if (set) {
                sb.append("add");
            } else {
                sb.append("remove");
            }
            if (node.isTemporary()) {
                sb.append("temp");
            }
            sb.append(" ").append(node.getGroupName());
            if (node.isTemporary() && set) {
                sb.append(" ").append(node.getExpiryUnixTime());
            }
            return NodeFactory.appendContextToCommand(sb, node, explicitGlobalContext).toString();
        }
        if (node.getValue() && (node.isPrefix() || node.isSuffix())) {
            ChatMetaType chatMetaType = node.isPrefix() ? ChatMetaType.PREFIX : ChatMetaType.SUFFIX;
            sb.append("meta ");
            if (set) {
                sb.append("add");
            } else {
                sb.append("remove");
            }
            if (node.isTemporary()) {
                sb.append("temp");
            }
            sb.append((Object)chatMetaType).append(" ").append(chatMetaType.getEntry(node).getKey()).append(" ");
            String value = chatMetaType.getEntry(node).getValue();
            if (value.contains(" ")) {
                sb.append("\"").append(value).append("\"");
            } else {
                sb.append(value);
            }
            if (set && node.isTemporary()) {
                sb.append(" ").append(node.getExpiryUnixTime());
            }
            return NodeFactory.appendContextToCommand(sb, node, explicitGlobalContext).toString();
        }
        if (node.getValue() && node.isMeta()) {
            sb.append("meta ");
            if (set) {
                sb.append("set");
            } else {
                sb.append("unset");
            }
            if (node.isTemporary()) {
                sb.append("temp");
            }
            sb.append(" ");
            String key = node.getMeta().getKey();
            if (key.contains(" ")) {
                sb.append("\"").append(key).append("\"");
            } else {
                sb.append(key);
            }
            if (set) {
                sb.append(" ");
                String value = node.getMeta().getValue();
                if (value.contains(" ")) {
                    sb.append("\"").append(value).append("\"");
                } else {
                    sb.append(value);
                }
                if (node.isTemporary()) {
                    sb.append(" ").append(node.getExpiryUnixTime());
                }
            }
            return NodeFactory.appendContextToCommand(sb, node, explicitGlobalContext).toString();
        }
        sb.append("permission ");
        if (set) {
            sb.append("set");
        } else {
            sb.append("unset");
        }
        if (node.isTemporary()) {
            sb.append("temp");
        }
        sb.append(" ");
        String perm = node.getPermission();
        if (perm.contains(" ")) {
            sb.append("\"").append(perm).append("\"");
        } else {
            sb.append(perm);
        }
        if (set) {
            sb.append(" ").append(node.getValue());
            if (node.isTemporary()) {
                sb.append(" ").append(node.getExpiryUnixTime());
            }
        }
        return NodeFactory.appendContextToCommand(sb, node, explicitGlobalContext).toString();
    }

    private static StringBuilder appendContextToCommand(StringBuilder sb, Node node, boolean explicitGlobalContext) {
        if (node.getFullContexts().isEmpty()) {
            if (explicitGlobalContext) {
                sb.append(" global");
            }
            return sb;
        }
        if (node.getServer().isPresent()) {
            sb.append(" server=").append(node.getServer().get());
        }
        if (node.getWorld().isPresent()) {
            sb.append(" world=").append(node.getWorld().get());
        }
        ContextSet contexts = node.getContexts();
        for (Map.Entry<String, String> context : contexts.toSet()) {
            sb.append(" ").append(context.getKey()).append("=").append(context.getValue());
        }
        return sb;
    }

    private NodeFactory() {
    }
}

