/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.NodeEqualityPredicate;

public final class NodeTools {
    public static <T extends Node> void removeEqual(Iterator<T> it, NodeEqualityPredicate equalityPredicate) {
        ArrayList<Node> alreadyIn = new ArrayList<Node>();
        block0: while (it.hasNext()) {
            Node next = (Node)it.next();
            for (Node other : alreadyIn) {
                if (!next.equals(other, equalityPredicate)) continue;
                it.remove();
                continue block0;
            }
            alreadyIn.add(next);
        }
    }

    public static <T extends Node> void removeSamePermission(Iterator<T> it) {
        HashSet<String> alreadyIn = new HashSet<String>();
        while (it.hasNext()) {
            Node next = (Node)it.next();
            if (alreadyIn.add(next.getPermission())) continue;
            it.remove();
        }
    }

    public static Predicate<? super LocalizedNode> localizedNodeComposedPredicate(Predicate<Node> delegate) {
        return localizedNode -> delegate.test(localizedNode.getNode());
    }

    private NodeTools() {
    }
}

