/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;

public class OptionInfo
extends SubCommand<LPSubjectData> {
    public OptionInfo(LocaleManager locale) {
        super(CommandSpec.SPONGE_OPTION_INFO.localize(locale), "info", CommandPermission.SPONGE_OPTION_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, List<String> args, String label) {
        ImmutableContextSet contextSet = ArgumentParser.parseContextSponge(0, args);
        if (contextSet.isEmpty()) {
            MessageUtils.sendPluginMessage(sender, "&aShowing options matching contexts &bANY&a.");
            ImmutableMap<ImmutableContextSet, ImmutableMap<String, String>> options = subjectData.getAllOptions();
            if (options.isEmpty()) {
                MessageUtils.sendPluginMessage(sender, "That subject does not have any options defined.");
                return CommandResult.SUCCESS;
            }
            for (Map.Entry e : options.entrySet()) {
                MessageUtils.sendPluginMessage(sender, "&3>> &bContext: " + SpongeCommandUtils.contextToString((ContextSet)e.getKey(), plugin.getLocaleManager()) + "\n" + SpongeCommandUtils.optionsToString((Map)e.getValue()));
            }
        } else {
            ImmutableMap<String, String> options = subjectData.getOptions(contextSet);
            if (options.isEmpty()) {
                MessageUtils.sendPluginMessage(sender, "That subject does not have any options defined in those contexts.");
                return CommandResult.SUCCESS;
            }
            MessageUtils.sendPluginMessage(sender, "&aShowing options matching contexts &b" + SpongeCommandUtils.contextToString(contextSet, plugin.getLocaleManager()) + "&a.\n" + SpongeCommandUtils.optionsToString(options));
        }
        return CommandResult.SUCCESS;
    }
}

