/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.listener;

import sonar.core.helpers.ListHelper;
import sonar.core.listener.ISonarListener;
import sonar.core.listener.ListenerList;

public class ListenerTally<T extends ISonarListener> {
    public T listener;
    public int[] tallies;
    public ListenerList<T> source;

    public ListenerTally(ListenerList<T> source, T listener, int types) {
        this.source = source;
        this.listener = listener;
        this.tallies = new int[types];
    }

    public int getTally(int type) {
        return this.tallies[type];
    }

    public int getTally(Enum type) {
        return this.getTally(type.ordinal());
    }

    public boolean hasTally(Enum type) {
        return this.getTally(type) > 0;
    }

    public boolean hasTally(int type) {
        return this.getTally(type) > 0;
    }

    public boolean isValid() {
        return this.listener != null && this.listener.isValid() && this.hasTallies();
    }

    public boolean hasTallies() {
        for (int i : this.tallies) {
            if (i <= 0) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.listener.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ListenerTally && this.listener.equals(((ListenerTally)obj).listener);
    }

    public void addTallies(int amount, Enum ... enums) {
        this.addTallies(amount, ListHelper.getOrdinals(enums));
    }

    public void addTallies(int amount, int ... types) {
        int[] nArray = types;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int type;
            int n2 = type = nArray[i];
            this.tallies[n2] = this.tallies[n2] + amount;
        }
    }

    public void removeTallies(int amount, Enum ... enums) {
        this.removeTallies(amount, ListHelper.getOrdinals(enums));
    }

    public void removeTallies(int amount, int ... types) {
        int[] nArray = types;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int type;
            int n2 = type = nArray[i];
            this.tallies[n2] = this.tallies[n2] - amount;
        }
    }
}

