/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;

public class SyncEnum<E extends Enum>
extends SyncPart {
    public E[] values;
    public E current;

    public SyncEnum(E[] values, int id) {
        super(id);
        this.values = values;
        this.current = values[0];
    }

    public SyncEnum(E[] values, String name) {
        super(name);
        this.values = values;
        this.current = values[0];
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(((Enum)this.current).ordinal());
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.setObject(this.values[buf.readInt()]);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.current != null) {
            nbt.func_74768_a(this.getTagName(), ((Enum)this.current).ordinal());
        }
        return nbt;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            this.setObject(((Enum[])this.values.clone())[nbt.func_74762_e(this.getTagName())]);
        }
    }

    public void incrementEnum() {
        int ordinal = ((Enum)this.current).ordinal() + 1;
        this.current = ordinal < this.values.length ? this.values[ordinal] : this.values[0];
        this.markChanged();
    }

    public SyncEnum<E> setDefault(E def) {
        this.current = def;
        return this;
    }

    public E getObject() {
        return this.current;
    }

    public void setObject(E object) {
        if (this.current != object) {
            this.current = object;
            this.markChanged();
        }
    }

    public String toString() {
        return ((Enum)this.current).toString();
    }
}

