/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import mcjty.lib.network.PacketUpdateNBTItem;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateNBTItemHandler<T extends PacketUpdateNBTItem>
implements IMessageHandler<T, IMessage> {
    public IMessage onMessage(T message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
        return null;
    }

    private void handle(T message, MessageContext ctx) {
        EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
        ItemStack heldItem = playerEntity.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        if (!((PacketUpdateNBTItem)message).isValidItem(heldItem)) {
            return;
        }
        NBTTagCompound tagCompound = heldItem.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            heldItem.func_77982_d(tagCompound);
        }
        for (Key<?> akey : ((PacketUpdateNBTItem)message).args.getKeys()) {
            String key = akey.getName();
            if (Type.STRING.equals(akey.getType())) {
                tagCompound.func_74778_a(key, (String)((PacketUpdateNBTItem)message).args.get(akey));
                continue;
            }
            if (Type.INTEGER.equals(akey.getType())) {
                tagCompound.func_74768_a(key, ((Integer)((PacketUpdateNBTItem)message).args.get(akey)).intValue());
                continue;
            }
            if (Type.LONG.equals(akey.getType())) {
                tagCompound.func_74772_a(key, ((Long)((PacketUpdateNBTItem)message).args.get(akey)).longValue());
                continue;
            }
            if (Type.DOUBLE.equals(akey.getType())) {
                tagCompound.func_74780_a(key, ((Double)((PacketUpdateNBTItem)message).args.get(akey)).doubleValue());
                continue;
            }
            if (Type.BOOLEAN.equals(akey.getType())) {
                tagCompound.func_74757_a(key, ((Boolean)((PacketUpdateNBTItem)message).args.get(akey)).booleanValue());
                continue;
            }
            if (Type.BLOCKPOS.equals(akey.getType())) {
                throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
            }
            if (Type.ITEMSTACK.equals(akey.getType())) {
                throw new RuntimeException("ItemStack not supported for PacketUpdateNBTItem!");
            }
            throw new RuntimeException(akey.getType().getType().getSimpleName() + " not supported for PacketUpdateNBTItem!");
        }
    }
}

