/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.compatibility.opencomputers;

import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.util.EnumFacing;
import omtteam.omlib.compatibility.opencomputers.AbstractOMTileEntityEnvironment;
import omtteam.omlib.tileentity.EnumMachineMode;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.TrustedPlayer;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class ManagedEnvironmentTurretBase
extends AbstractOMTileEntityEnvironment<TurretBase>
implements NamedBlock {
    private final TurretBase base;

    ManagedEnvironmentTurretBase(TurretBase base) {
        super((Object)base, "turret_base");
        this.base = base;
    }

    public String preferredName() {
        return "turret_base";
    }

    public int priority() {
        return 10;
    }

    @Callback(doc="function():string; returns owner of turret base.")
    public Object[] getOwner(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.base.getOwnerName()};
    }

    @Callback(doc="function():boolean; returns if the turret is currently set to attack hostile mobs.")
    public Object[] isAttacksMobs(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.base.isAttacksMobs()};
    }

    @Callback(doc="function(state:boolean):void; set attack hostile mobs or not.")
    public Object[] setAttacksMobs(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.base.setAttacksMobs(args.checkBoolean(0));
        return null;
    }

    @Callback(doc="function():boolean; returns if the turret is currently set to attack neutral mobs.")
    public Object[] isAttacksNeutrals(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.base.isAttacksNeutrals()};
    }

    @Callback(doc="function(state:boolean):void; set attack neutral mobs or not.")
    public Object[] setAttacksNeutrals(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.base.setAttacksNeutrals(args.checkBoolean(0));
        return null;
    }

    @Callback(doc="function():boolean; returns if the turret is currently set to attack players.")
    public Object[] isAttacksPlayers(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.base.isAttacksPlayers()};
    }

    @Callback(doc="function(state:boolean):void; sets attack players or not.")
    public Object[] setAttacksPlayers(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.base.setAttacksPlayers(args.checkBoolean(0));
        return null;
    }

    @Callback(doc="function():table; returns a table of all trusted players on this base.")
    public Object[] getTrustedPlayers(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.base.getTrustedPlayers()};
    }

    @Callback(doc="function(name:String, [canOpenGUI:boolean, canChangeTargeting:boolean, admin:boolean]):string; adds Trusted player to Trustlist. Can return error.")
    public Object[] addTrustedPlayer(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!this.base.addTrustedPlayer(args.checkString(0))) {
            return new Object[]{"Name not valid!"};
        }
        TrustedPlayer trustedPlayer = this.base.getTrustedPlayer(args.checkString(0));
        trustedPlayer.canOpenGUI = args.optBoolean(1, false);
        trustedPlayer.canChangeTargeting = args.optBoolean(1, false);
        trustedPlayer.admin = args.optBoolean(1, false);
        trustedPlayer.uuid = PlayerUtil.getPlayerUUID((String)args.checkString(0));
        return null;
    }

    @Callback(doc="function(name:String):string; removes trusted player from trust list.")
    public Object[] removeTrustedPlayer(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.base.removeTrustedPlayer(args.checkString(0));
        return null;
    }

    @Callback(doc="function():int; returns maximum energy storage.")
    public Object[] getMaxEnergyStorage(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.base.getMaxEnergyLevel(EnumFacing.DOWN)};
    }

    @Callback(doc="function():int; returns current energy stored.")
    public Object[] getCurrentEnergyStorage(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.base.getEnergyLevel(EnumFacing.DOWN)};
    }

    @Callback(doc="function():boolean; returns if the turret is currently active.")
    public Object[] getActive(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.base.isActive()};
    }

    @Callback(doc="function(state:int):void; toggles turret redstone inversion state.")
    public Object[] setMode(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isInteger(0) || args.checkInteger(0) <= EnumMachineMode.values().length) {
            return new Object[]{"Set first parameter to any number between 0 and " + EnumMachineMode.values().length, "0 - Always on, 1 - always off, 2 - inverted, 3 - not inverted"};
        }
        this.base.setMode(EnumMachineMode.values()[args.checkInteger(0)]);
        return null;
    }

    @Callback(doc="function():int; shows base mode.")
    public Object[] getMode(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        switch (this.base.getMode().ordinal()) {
            case 0: {
                return new Object[]{"0 - Always on"};
            }
            case 1: {
                return new Object[]{"1 - always off"};
            }
            case 2: {
                return new Object[]{"2 - inverted"};
            }
            case 3: {
                return new Object[]{"3 - not inverted"};
            }
        }
        return new Object[0];
    }

    @Callback(doc="function():boolean; shows redstone state.")
    public Object[] getRedstone(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.base.getRedstone()};
    }

    @Callback(doc="function(yaw:double, pitch:double):void; Set yaw and pitch for all turrets (deact. auto targ. before).")
    public Object[] setAllYawPitch(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isDouble(0) || !args.isDouble(1)) {
            return new Object[]{"Wrong parameters!"};
        }
        this.base.setAllTurretsYawPitch((float)args.checkDouble(0), (float)args.checkDouble(1));
        return new Object[0];
    }

    @Callback(doc="function(side:int, yaw:double, pitch:double):boolean; Set yaw and pitch for a turret (deact. auto targ. before).")
    public Object[] setTurretYawPitch(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isInteger(0) || args.checkInteger(0) > 6 || args.checkInteger(0) < 0 || args.isDouble(1) || !args.isDouble(2)) {
            return new Object[]{"Wrong parameters!"};
        }
        return new Object[]{this.base.setTurretYawPitch(EnumFacing.func_82600_a((int)args.checkInteger(0)), (float)args.checkDouble(0), (float)args.checkDouble(1))};
    }

    @Callback(doc="function(state:boolean):void; Enable auto firing for all Turrets (deact. auto targ. before).")
    public Object[] setAllAutoForceFire(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isBoolean(0)) {
            return new Object[]{"Wrong parameters!"};
        }
        this.base.setAllTurretsForceFire(args.checkBoolean(0));
        return new Object[0];
    }

    @Callback(doc="function(side:int, state:boolean):boolean; Enable auto firing for specified Turret (deact. auto targ. before).")
    public Object[] setTurretAutoForceFire(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isInteger(0) || args.checkInteger(0) > 6 || args.checkInteger(0) < 0 || !args.isBoolean(1)) {
            return new Object[]{"Wrong parameters!"};
        }
        return new Object[]{this.base.setTurretForceFire(EnumFacing.func_82600_a((int)args.checkInteger(0)), args.checkBoolean(1))};
    }

    @Callback(doc="function():int; Try to shoot all turrets, returns number of successful shots")
    public Object[] forceShootAll(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.base.forceShootAllTurrets()};
    }

    @Callback(doc="function(side:int):boolean; Try to shoot specified turret, returns true if successful")
    public Object[] forceShootTurret(Context context, Arguments args) {
        if (!this.base.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isInteger(0) && args.checkInteger(0) <= 6 && args.checkInteger(0) >= 0) {
            return new Object[]{"Wrong parameters!"};
        }
        return new Object[]{this.base.forceShootTurret(EnumFacing.func_82600_a((int)args.checkInteger(0)))};
    }
}

