/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity.turrets;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.tileentity.ITrustedPlayersManager;
import omtteam.omlib.tileentity.TileEntityBase;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.MathUtil;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.RandomUtil;
import omtteam.openmodularturrets.api.ITurretBaseAddonTileEntity;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.handler.OMTConfigHandler;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.tileentity.turrets.RocketTurretTileEntity;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public abstract class TurretHead
extends TileEntityBase
implements ITickable,
ITurretBaseAddonTileEntity {
    int ticks;
    int targetingTicks;
    public float pitch;
    public float yaw;
    public float baseFitRotationX;
    public float baseFitRotationZ;
    int turretTier;
    protected TurretBase base;
    private boolean hasSetSide = false;
    private EnumFacing turretBase;
    public Entity target = null;
    public float rotationAnimation = 0.0f;
    public boolean shouldConceal = false;
    private boolean playedDeploy = false;
    private boolean autoFire = false;
    private int ticksWithoutTarget;
    private double targetLastX = 0.0;
    private double targetLastY = 0.0;
    private double targetLastZ = 0.0;
    private double targetSpeedX = 0.0;
    private double targetSpeedY = 0.0;
    private double targetSpeedZ = 0.0;
    private float maxPitch = 360.0f;
    private float maxYaw = 360.0f;
    private float minPitch = 0.0f;
    private float minYaw = 0.0f;

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_189515_b(var1);
        return new SPacketUpdateTileEntity(this.field_174879_c, 2, var1);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound var1 = pkt.func_148857_g();
        this.func_145839_a(var1);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74776_a("pitch", this.pitch);
        nbtTagCompound.func_74776_a("yaw", this.yaw);
        nbtTagCompound.func_74768_a("ticksBeforeFire", this.ticks);
        nbtTagCompound.func_74757_a("shouldConceal", this.shouldConceal);
        nbtTagCompound.func_74757_a("autoFire", this.autoFire);
        nbtTagCompound.func_74776_a("maxPitch", this.maxPitch);
        nbtTagCompound.func_74776_a("minPitch", this.minPitch);
        nbtTagCompound.func_74776_a("maxYaw", this.maxYaw);
        nbtTagCompound.func_74776_a("minYaw", this.minYaw);
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.pitch = par1.func_74760_g("pitch");
        this.yaw = par1.func_74760_g("yaw");
        this.shouldConceal = par1.func_74767_n("shouldConceal");
        this.autoFire = par1.func_74767_n("autoFire");
    }

    @Nonnull
    public TileEntityOwnedBlock getLinkedBlock() {
        return this.base;
    }

    boolean setSide() {
        if (this.hasSetSide && !this.func_145831_w().func_175667_e(this.func_174877_v().func_177972_a(this.turretBase))) {
            return false;
        }
        if (this.hasSetSide) {
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177974_f()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177974_f()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 1.565f;
            this.turretBase = EnumFacing.EAST;
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177976_e()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177976_e()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 4.705f;
            this.turretBase = EnumFacing.WEST;
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177968_d()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177968_d()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 3.145f;
            this.turretBase = EnumFacing.SOUTH;
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177978_c()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177978_c()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 0.0f;
            this.turretBase = EnumFacing.NORTH;
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177984_a()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177984_a()) instanceof TurretBase) {
            this.baseFitRotationX = 3.145f;
            this.baseFitRotationZ = 0.0f;
            this.turretBase = EnumFacing.UP;
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177977_b()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177977_b()) instanceof TurretBase) {
            this.baseFitRotationX = 0.0f;
            this.baseFitRotationZ = 0.0f;
            this.turretBase = EnumFacing.DOWN;
            this.hasSetSide = true;
            return true;
        }
        return false;
    }

    Entity getTargetWithMinRange() {
        return TurretHeadUtil.getTargetWithMinimumRange(this.base, this.func_145831_w(), this.field_174879_c, Math.min(this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(this.base), this.base.getCurrentMaxRange()), this);
    }

    Entity getTargetWithoutEffect() {
        return TurretHeadUtil.getTargetWithoutSlowEffect(this.base, this.func_145831_w(), this.field_174879_c, Math.min(this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(this.base), this.base.getCurrentMaxRange()), this);
    }

    private Entity getTarget() {
        return TurretHeadUtil.getTarget(this.base, this.func_145831_w(), this.field_174879_c, Math.min(this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(this.base), this.base.getCurrentMaxRange()), this);
    }

    public abstract int getTurretRange();

    TurretBase getBaseFromWorld() {
        return TurretHeadUtil.getTurretBase(this.func_145831_w(), this.field_174879_c);
    }

    public TurretBase getBase() {
        return this.base;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getMaxPitch() {
        return this.maxPitch;
    }

    public void setMaxPitch(float maxPitch) {
        this.maxPitch = maxPitch;
    }

    public float getMinPitch() {
        return this.minPitch;
    }

    public void setMinPitch(float minPitch) {
        this.minPitch = minPitch;
    }

    public float getMaxYaw() {
        return this.maxYaw;
    }

    public void setMaxYaw(float maxYaw) {
        this.maxYaw = maxYaw;
    }

    public float getMinYaw() {
        return this.minYaw;
    }

    public void setMinYaw(float minYaw) {
        this.minYaw = minYaw;
    }

    public boolean getAutoFire() {
        return this.autoFire;
    }

    public void setAutoFire(boolean autoFire) {
        this.autoFire = autoFire;
    }

    public abstract int getTurretPowerUsage();

    public abstract int getTurretFireRate();

    public abstract double getTurretAccuracy();

    public abstract double getTurretDamageAmpBonus();

    protected abstract boolean requiresAmmo();

    protected abstract boolean requiresSpecificAmmo();

    protected abstract float getProjectileGravity();

    public abstract ItemStack getAmmo();

    protected abstract TurretProjectile createProjectile(World var1, Entity var2, ItemStack var3);

    protected abstract SoundEvent getLaunchSoundEffect();

    boolean chebyshevDistance(Entity target, TurretBase base) {
        Vec3d targetPos = new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        return MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(targetPos.field_72450_a - (double)this.func_174877_v().func_177958_n()), (double)(targetPos.field_72448_b - (double)this.func_174877_v().func_177956_o())), (double)(targetPos.field_72449_c - (double)this.func_174877_v().func_177952_p())) > (double)this.getBaseFromWorld().getCurrentMaxRange();
    }

    private int getPowerRequiredForNextShot() {
        return Math.round((float)this.getTurretPowerUsage() * (1.0f - TurretHeadUtil.getEfficiencyUpgrades(this.base)) * (float)(1 + TurretHeadUtil.getScattershotUpgrades(this.base)));
    }

    private void updateRotationAnimation() {
        if (this.rotationAnimation >= 360.0f) {
            this.rotationAnimation = 0.0f;
        }
        this.rotationAnimation += 0.03f;
    }

    private ItemStack getAmmoStack() {
        ItemStack ammo;
        block4: {
            ammo = ItemStack.field_190927_a;
            if (!this.requiresAmmo()) break block4;
            if (this.requiresSpecificAmmo()) {
                for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                    ammo = TurretHeadUtil.getSpecificItemStackItemFromBase(this.base, this.getAmmo());
                    if (ammo != ItemStack.field_190927_a) continue;
                    ammo = TurretHeadUtil.getSpecificItemFromInvExpanders(this.func_145831_w(), this.getAmmo(), this.base);
                }
            } else {
                for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                    ammo = TurretHeadUtil.getDisposableAmmoFromBase(this.base);
                    if (ammo != ItemStack.field_190927_a) continue;
                    ammo = TurretHeadUtil.getDisposableAmmoFromInvExpander(this.func_145831_w(), this.base);
                }
            }
        }
        return ammo;
    }

    private boolean isTargetInYawPitch(Entity entity) {
        while (this.yaw > 360.0f || this.pitch > 360.0f || this.yaw < 0.0f || this.pitch < 0.0f) {
            if (this.yaw > 360.0f) {
                this.yaw -= 360.0f;
            }
            if (this.pitch > 360.0f) {
                this.pitch -= 360.0f;
            }
            if (this.yaw < 0.0f) {
                this.yaw += 360.0f;
            }
            if (!(this.pitch < 0.0f)) continue;
            this.pitch += 360.0f;
        }
        return this.minYaw <= this.yaw && this.yaw <= this.maxYaw && this.minPitch <= this.pitch && this.pitch <= this.maxPitch;
    }

    public void func_73660_a() {
        if (!this.setSide()) {
            return;
        }
        this.base = this.getBaseFromWorld();
        if (this.func_145831_w().field_72995_K) {
            this.updateRotationAnimation();
            return;
        }
        if (!(this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() instanceof BlockAbstractTurretHead)) {
            return;
        }
        if (this.ticks % 5 == 0) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
        }
        ++this.ticks;
        if (this.base == null || this.base.getTier() < this.turretTier) {
            this.func_145831_w().func_175655_b(this.field_174879_c, true);
            return;
        }
        if (!this.base.isActive()) {
            return;
        }
        TurretHeadUtil.updateSolarPanelAddon(this.base);
        this.concealmentChecks();
        if (this.base.getEnergyLevel(EnumFacing.DOWN) < this.getPowerRequiredForNextShot()) {
            return;
        }
        if (this.base.isAttacksPlayers() && OMTConfigHandler.globalCanTargetPlayers) {
            TurretHeadUtil.warnPlayers(this.base, this.base.func_145831_w(), this.field_174879_c, this.getTurretRange());
        }
        if (this.target instanceof EntityPlayerMP) {
            this.targetSpeedX = this.target.field_70165_t - this.targetLastX;
            this.targetSpeedY = this.target.field_70163_u - this.targetLastY;
            this.targetSpeedZ = this.target.field_70161_v - this.targetLastZ;
            this.targetLastX = this.target.field_70165_t;
            this.targetLastY = this.target.field_70163_u;
            this.targetLastZ = this.target.field_70161_v;
        }
        if (this.target == null && this.targetingTicks < OMTConfigHandler.getTurretTargetSearchTicks()) {
            ++this.targetingTicks;
        } else {
            this.targetingChecks();
            if (this.target != null && this.isTargetInYawPitch(this.target)) {
                this.yaw = TurretHeadUtil.getAimYaw(this.target, this.field_174879_c);
                this.pitch = TurretHeadUtil.getAimPitch(this.target, this.field_174879_c);
            }
            this.targetingTicks = 0;
        }
        if (this.target != null || this.autoFire) {
            if ((float)this.ticks < (float)this.getTurretFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(this.base))) {
                return;
            }
            ItemStack ammo = this.getAmmoStack();
            if (ammo == ItemStack.field_190927_a && this.requiresAmmo()) {
                return;
            }
            if (this.target != null) {
                this.doTargetedShot(this.target, ammo);
            } else if (this.autoFire) {
                this.doBlindShot(ammo);
            }
            this.ticks = 0;
        }
    }

    private void doTargetedShot(Entity target, ItemStack ammo) {
        double speedX = target instanceof EntityPlayerMP ? this.targetSpeedX : target.field_70165_t - target.field_70169_q;
        double speedY = target instanceof EntityPlayerMP ? this.targetSpeedY : target.field_70163_u - target.field_70167_r;
        double speedZ = target instanceof EntityPlayerMP ? this.targetSpeedZ : target.field_70161_v - target.field_70166_s;
        double d0 = target.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
        double d1 = target.field_70163_u + (double)target.field_70131_O * 0.5 - ((double)this.field_174879_c.func_177956_o() + 0.5);
        double d2 = target.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5);
        double dist = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
        double inaccuracy = this.getTurretAccuracy() * (double)(1.0f - TurretHeadUtil.getAccuraccyUpgrades(this.base)) * (double)(1 + TurretHeadUtil.getScattershotUpgrades(this.base));
        double time = dist / (this.getProjectileGravity() == 0.0f ? 3.0 : 1.6);
        double adjustedX = d0 + speedX * time;
        double adjustedY = d1 + speedY * time;
        double adjustedZ = d2 + speedZ * time;
        double dist2 = MathHelper.func_76133_a((double)(adjustedX * adjustedX + adjustedY * adjustedY + adjustedZ * adjustedZ));
        float speedFactor = (float)(dist2 / dist);
        this.shootProjectile(adjustedX, adjustedY - (double)0.1f, adjustedZ, 3.0f * speedFactor, (float)inaccuracy, ammo);
    }

    private void doBlindShot(ItemStack ammo) {
        if (this instanceof RocketTurretTileEntity && OMTConfigHandler.canRocketsHome) {
            return;
        }
        Vec3d velocity = MathUtil.getVelocityVectorFromYawPitch((float)this.pitch, (float)this.yaw, (float)3.0f);
        double adjustedX = velocity.field_72450_a;
        double adjustedY = velocity.field_72448_b;
        double adjustedZ = velocity.field_72449_c;
        float speedFactor = (float)velocity.func_72433_c();
        double accuracy = this.getTurretAccuracy() * (double)(1.0f - TurretHeadUtil.getAccuraccyUpgrades(this.base)) * (double)(1 + TurretHeadUtil.getScattershotUpgrades(this.base));
        this.shootProjectile(adjustedX, adjustedY, adjustedZ, speedFactor, (float)accuracy, ammo);
    }

    public boolean forceShot() {
        if (this instanceof RocketTurretTileEntity && OMTConfigHandler.canRocketsHome) {
            return false;
        }
        if ((float)this.ticks < (float)this.getTurretFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(this.base))) {
            return false;
        }
        ItemStack ammo = this.getAmmoStack();
        if (ammo == ItemStack.field_190927_a && this.requiresAmmo()) {
            return false;
        }
        this.base.setEnergyStored(this.base.getEnergyStored(EnumFacing.DOWN) - this.getPowerRequiredForNextShot());
        for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
            Vec3d velocity;
            double accuracy = this.getTurretAccuracy() * (double)(1.0f - TurretHeadUtil.getAccuraccyUpgrades(this.base)) * (double)(1 + TurretHeadUtil.getScattershotUpgrades(this.base));
            TurretProjectile projectile = this.createProjectile(this.func_145831_w(), this.target, ammo);
            projectile.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            if (projectile.gravity == 0.0f) {
                velocity = MathUtil.getVelocityVectorFromYawPitch((float)this.pitch, (float)this.yaw, (float)3.0f);
                projectile.func_70186_c(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, (float)velocity.func_72433_c(), (float)accuracy);
            } else {
                projectile.field_70177_z = this.yaw;
                projectile.field_70125_A = this.pitch;
                velocity = MathUtil.getVelocityVectorFromYawPitch((float)projectile.field_70177_z, (float)projectile.field_70125_A, (float)1.6f);
                projectile.field_70159_w = velocity.field_72450_a + RandomUtil.random.nextGaussian() * (double)0.0075f * accuracy;
                projectile.field_70181_x = velocity.field_72448_b + RandomUtil.random.nextGaussian() * (double)0.0075f * accuracy;
                projectile.field_70179_y = velocity.field_72449_c + RandomUtil.random.nextGaussian() * (double)0.0075f * accuracy;
                projectile.field_70126_B = projectile.field_70177_z;
                projectile.field_70127_C = projectile.field_70125_A;
            }
            this.func_145831_w().func_72838_d((Entity)projectile);
        }
        this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getLaunchSoundEffect(), SoundCategory.BLOCKS, OMTConfigHandler.getTurretSoundVolume(), new Random().nextFloat() + 0.5f);
        this.ticks = 0;
        return true;
    }

    private void shootProjectile(double adjustedX, double adjustedY, double adjustedZ, float speedFactor, float accuracy, ItemStack ammo) {
        this.base.setEnergyStored(this.base.getEnergyLevel(EnumFacing.DOWN) - this.getPowerRequiredForNextShot());
        for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
            TurretProjectile projectile = this.createProjectile(this.func_145831_w(), this.target, ammo);
            projectile.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            projectile.func_70186_c(adjustedX, adjustedY, adjustedZ, speedFactor, accuracy);
            projectile.amp_level = TurretHeadUtil.getAmpLevel(this.base);
            if (projectile.amp_level != 0) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, ModSounds.amped, SoundCategory.BLOCKS, OMTConfigHandler.getTurretSoundVolume(), RandomUtil.random.nextFloat() + 0.5f);
                projectile.isAmped = true;
            }
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getLaunchSoundEffect(), SoundCategory.BLOCKS, OMTConfigHandler.getTurretSoundVolume(), new Random().nextFloat() + 0.5f);
            this.func_145831_w().func_72838_d((Entity)projectile);
        }
    }

    private void targetingChecks() {
        if (this.target == null || this.target.field_70128_L || this.func_145831_w().func_73045_a(this.target.func_145782_y()) == null || ((EntityLivingBase)this.target).func_110143_aJ() <= 0.0f) {
            this.target = this.getTarget();
        }
        if (this.target != null) {
            EntityPlayerMP entity;
            if (this.target instanceof EntityPlayerMP && (PlayerUtil.isPlayerTrusted((EntityPlayer)(entity = (EntityPlayerMP)this.target), (ITrustedPlayersManager)this.base) || entity.field_71075_bZ.field_75098_d || !this.base.isAttacksPlayers())) {
                this.target = null;
                return;
            }
            if (!TurretHeadUtil.canTurretSeeTarget(this, (EntityLivingBase)this.target)) {
                this.target = null;
                return;
            }
            if (this.chebyshevDistance(this.target, this.base)) {
                this.target = null;
            }
        }
    }

    void concealmentChecks() {
        if (this.base != null && this.base.shouldConcealTurrets) {
            if (!(this.shouldConceal || this.target != null && TurretHeadUtil.canTurretSeeTarget(this, (EntityLivingBase)this.target) || this.ticksWithoutTarget < 40)) {
                this.ticksWithoutTarget = 0;
                this.shouldConceal = true;
                this.playedDeploy = false;
                this.func_145831_w().func_184133_a(null, this.field_174879_c, ModSounds.turretRetractSound, SoundCategory.BLOCKS, OMTConfigHandler.getTurretSoundVolume(), new Random().nextFloat() + 0.5f);
                this.func_145831_w().func_180501_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                ++this.ticksWithoutTarget;
            }
            if (this.base != null && this.target != null) {
                this.ticksWithoutTarget = 0;
                this.shouldConceal = false;
                if (!this.playedDeploy) {
                    this.func_145831_w().func_184133_a(null, this.field_174879_c, ModSounds.turretDeploySound, SoundCategory.BLOCKS, OMTConfigHandler.getTurretSoundVolume(), new Random().nextFloat() + 0.5f);
                    this.playedDeploy = true;
                    this.func_145831_w().func_180501_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        } else {
            this.shouldConceal = false;
            this.func_145831_w().func_180501_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

