/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.api.exceptions.NucleusException;
import io.github.nucleuspowered.nucleus.api.exceptions.PluginAlreadyRegisteredException;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Tuple;

public interface NucleusMessageTokenService {
    public void register(PluginContainer var1, TokenParser var2) throws PluginAlreadyRegisteredException;

    public boolean unregister(PluginContainer var1);

    public boolean registerPrimaryToken(String var1, PluginContainer var2, String var3);

    default public Optional<TokenParser> getTokenParser(PluginContainer pluginContainer) {
        Preconditions.checkNotNull((Object)pluginContainer, (Object)"pluginContainer");
        return this.getTokenParser(pluginContainer.getId());
    }

    public Optional<TokenParser> getTokenParser(String var1);

    default public Optional<Text> applyToken(String plugin, String token, CommandSource source) {
        return this.applyToken(plugin, token, source, Maps.newHashMap());
    }

    public Optional<Tuple<TokenParser, String>> getPrimaryTokenParserAndIdentifier(String var1);

    public List<String> getPrimaryTokens();

    default public Optional<Text> applyToken(String plugin, String token, CommandSource source, Map<String, Object> variables) {
        Optional<TokenParser> tokenFunction = this.getTokenParser(plugin);
        return tokenFunction.flatMap(tokenParser -> tokenParser.parse(token, source, variables));
    }

    default public Optional<Text> applyPrimaryToken(String primaryToken, CommandSource source) {
        return this.applyPrimaryToken(primaryToken, source, Maps.newHashMap());
    }

    default public Optional<Text> applyPrimaryToken(String primaryToken, CommandSource source, Map<String, Object> variables) {
        Preconditions.checkArgument((primaryToken != null && !primaryToken.isEmpty() ? 1 : 0) != 0);
        String[] tokenData = primaryToken.split("\\|", 2);
        return this.getPrimaryTokenParserAndIdentifier(tokenData[0].toLowerCase()).flatMap(x -> ((TokenParser)x.getFirst()).parse(tokenData.length == 2 ? (String)x.getSecond() + "|" + tokenData[1] : (String)x.getSecond(), source, variables));
    }

    default public Optional<Text> parseToken(String token, CommandSource source) {
        return this.parseToken(token, source, null);
    }

    public Optional<Text> parseToken(String var1, CommandSource var2, @Nullable Map<String, Object> var3);

    public boolean registerTokenFormat(String var1, String var2, String var3) throws IllegalArgumentException;

    public NucleusTextTemplate createFromString(String var1) throws NucleusException;

    @FunctionalInterface
    public static interface TokenParser {
        @Nonnull
        public Optional<Text> parse(String var1, CommandSource var2, Map<String, Object> var3);
    }
}

