/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.dataservices.modular;

import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.dataservices.AbstractService;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.DataProvider;
import io.github.nucleuspowered.nucleus.dataservices.modular.DataModule;
import io.github.nucleuspowered.nucleus.dataservices.modular.TransientModule;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;

public abstract class ModularDataService<S extends ModularDataService<S>>
extends AbstractService<ConfigurationNode> {
    protected static final Object[] VERSION_PATH = new Object[]{"version"};
    private final Map<Class<?>, DataModule<S>> cached = new HashMap();
    private final Map<Class<?>, TransientModule<S>> transientCache = new HashMap();
    private final Timing saveTimings = Timings.of((Object)Nucleus.getNucleus(), (String)"Data Modules - Saving");
    private final Timing loadTimings = Timings.of((Object)Nucleus.getNucleus(), (String)"Data Modules - Loading");
    private final Timing loadTransientTimings = Timings.of((Object)Nucleus.getNucleus(), (String)"Transient Modules - Loading");
    private final Object lockingObject = new Object();

    ModularDataService(DataProvider<ConfigurationNode> dataProvider) {
        super(dataProvider);
    }

    public final <T extends TransientModule<S>> T getTransient(Class<T> module) {
        if (this.transientCache.containsKey(module)) {
            return (T)this.transientCache.get(module);
        }
        try {
            TransientModule dm;
            this.loadTransientTimings.startTimingIfSync();
            Optional<T> m = this.tryGetTransient(module);
            if (m.isPresent()) {
                dm = (TransientModule)m.get();
            } else {
                Nucleus.getNucleus().getLogger().warn("Attempting to construct " + module.getSimpleName() + " by reflection. Please add this to the factory.");
                dm = (TransientModule)module.newInstance();
            }
            this.setTransient(dm);
            TransientModule transientModule = dm;
            return (T)transientModule;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.loadTransientTimings.stopTimingIfSync();
        }
    }

    abstract <T extends TransientModule<S>> Optional<T> tryGetTransient(Class<T> var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T extends DataModule<S>> T get(Class<T> module) {
        Object object = this.lockingObject;
        synchronized (object) {
            if (this.cached.containsKey(module)) {
                return (T)this.cached.get(module);
            }
            try {
                DataModule dm;
                this.loadTimings.startTimingIfSync();
                Optional<T> m = this.tryGet(module);
                if (m.isPresent()) {
                    dm = (DataModule)m.get();
                } else {
                    Nucleus.getNucleus().getLogger().warn("Attempting to construct " + module.getSimpleName() + " by reflection. Please add this to the factory.");
                    if (DataModule.ReferenceService.class.isAssignableFrom(module)) {
                        Constructor<T> s = module.getDeclaredConstructor(this.getClass());
                        s.setAccessible(true);
                        dm = (DataModule)s.newInstance(this);
                    } else {
                        dm = (DataModule)module.newInstance();
                    }
                }
                dm.loadFrom((ConfigurationNode)this.data);
                this.set(dm);
                DataModule dataModule = dm;
                return (T)dataModule;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                this.loadTimings.stopTimingIfSync();
            }
        }
    }

    abstract <T extends DataModule<S>> Optional<T> tryGet(Class<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DataModule<S>> void set(T dataModule) {
        Object object = this.lockingObject;
        synchronized (object) {
            this.cached.put(dataModule.getClass(), dataModule);
        }
    }

    private <T extends TransientModule<S>> void setTransient(T dataModule) {
        this.transientCache.put(dataModule.getClass(), dataModule);
    }

    @Override
    public void loadInternal() throws Exception {
        super.loadInternal();
        this.cached.clear();
        int version = ((ConfigurationNode)this.data).getNode(VERSION_PATH).getInt(-1);
        this.migrate();
        int newVersion = ((ConfigurationNode)this.data).getNode(VERSION_PATH).getInt(-1);
        if (version != newVersion) {
            this.saveInternal();
        }
    }

    @Override
    public void saveInternal() throws Exception {
        try {
            this.saveTimings.startTimingIfSync();
            if (this.data != null && (!this.cached.isEmpty() || !((ConfigurationNode)this.data).isVirtual() && ((ConfigurationNode)this.data).getValue() != null)) {
                ImmutableMap.copyOf(this.cached).values().forEach(x -> x.saveTo((ConfigurationNode)this.data));
                super.saveInternal();
            }
        }
        finally {
            this.saveTimings.stopTimingIfSync();
        }
    }

    public void migrate() {
    }
}

