/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfigAdapter;
import io.github.nucleuspowered.nucleus.util.Tuples;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextElement;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

public class TextParsingUtils
implements Reloadable,
MessageProviderTrait,
InternalServiceManagerTrait {
    private static final Pattern colours = Pattern.compile(".*?(?<colour>(&[0-9a-flmnrok])+)$");
    private final Pattern enhancedUrlParser = Pattern.compile("(?<first>(^|\\s))(?<reset>&r)?(?<colour>(&[0-9a-flmnrok])+)?((?<options>\\{[a-z]+?})?(?<url>(http(s)?://)?([A-Za-z0-9]+\\.)+[A-Za-z0-9-]{2,}\\S*)|(?<specialUrl>(\\[(?<msg>.+?)](?<optionssurl>\\{[a-z]+})?\\((?<sUrl>(http(s)?://)?([A-Za-z0-9-]+\\.)+[A-Za-z0-9]{2,}[^\\s)]*)\\)))|(?<specialCmd>(\\[(?<sMsg>.+?)](?<optionsscmd>\\{[a-z]+})?\\((?<sCmd>/.+?)\\))))", 2);
    private static final Pattern urlParser = Pattern.compile("(?<first>(^|\\s))(?<reset>&r)?(?<colour>(&[0-9a-flmnrok])+)?(?<options>\\{[a-z]+?})?(?<url>(http(s)?://)?([A-Za-z0-9-]+\\.)+[A-Za-z0-9]{2,}\\S*)", 2);
    private static final StyleTuple EMPTY = new StyleTuple(TextColors.NONE, TextStyles.NONE);
    private String commandNameOnClick;

    public static Text addUrls(String message) {
        return TextParsingUtils.addUrls(message, false);
    }

    public static Text addUrls(String message, boolean replaceBlueUnderline) {
        if (message == null || message.isEmpty()) {
            return Text.EMPTY;
        }
        Matcher m = urlParser.matcher(message);
        if (!m.find()) {
            return TextSerializers.FORMATTING_CODE.deserialize(message);
        }
        ArrayList texts = Lists.newArrayList();
        String remaining = message;
        StyleTuple st = EMPTY;
        do {
            String[] textArray = remaining.split(urlParser.pattern(), 2);
            Text first = Text.builder().color(st.colour).style(new TextStyle[]{st.style}).append(new Text[]{TextSerializers.FORMATTING_CODE.deserialize(textArray[0])}).build();
            texts.add(first);
            remaining = textArray.length == 2 ? textArray[1] : null;
            String colourMatch = m.group("colour");
            if (replaceBlueUnderline) {
                st = new StyleTuple(TextColors.BLUE, (TextStyle)TextStyles.UNDERLINE);
            } else if (colourMatch != null && !colourMatch.isEmpty()) {
                TextStyle reset = TextStyles.NONE;
                if (m.group("reset") != null) {
                    reset = TextStyles.RESET;
                }
                st = TextParsingUtils.getLastColourAndStyle((TextRepresentable)Text.of((Object[])new Object[]{reset, TextSerializers.FORMATTING_CODE.deserialize(m.group("colour") + " ")}), st);
            } else {
                st = TextParsingUtils.getLastColourAndStyle((TextRepresentable)first, st);
            }
            String whiteSpace = m.group("first");
            st = replaceBlueUnderline ? new StyleTuple(TextColors.BLUE, (TextStyle)TextStyles.UNDERLINE) : TextParsingUtils.getLastColourAndStyle((TextRepresentable)first, st);
            String url = m.group("url");
            if (url.endsWith("&r")) {
                String url2 = url.replaceAll("&r$", "");
                texts.add(TextParsingUtils.getTextForUrl(url2, url2, whiteSpace, st, m.group("options")));
            } else {
                texts.add(TextParsingUtils.getTextForUrl(url, url, whiteSpace, st, m.group("options")));
            }
            if (!replaceBlueUnderline) continue;
            st = TextParsingUtils.getLastColourAndStyle((TextRepresentable)first, st, TextColors.WHITE, TextStyles.NONE);
        } while (remaining != null && m.find());
        if (remaining != null) {
            texts.add(Text.builder().color(st.colour).style(new TextStyle[]{st.style}).append(new Text[]{TextSerializers.FORMATTING_CODE.deserialize(remaining)}).build());
        }
        return Text.of((Object[])texts.toArray(new TextElement[texts.size()]));
    }

    public static Text oldLegacy(String message) {
        Matcher colourMatcher = colours.matcher(message);
        if (colourMatcher.matches()) {
            Text first = TextSerializers.FORMATTING_CODE.deserialize(message.replace(colourMatcher.group("colour"), ""));
            String match = colourMatcher.group("colour") + " ";
            Text t = TextSerializers.FORMATTING_CODE.deserialize(match);
            return Text.of((Object[])new Object[]{first, t.getColor(), first.getStyle().and(new TextStyle[]{t.getStyle()})});
        }
        return TextSerializers.FORMATTING_CODE.deserialize(message);
    }

    public Tuples.NullableTuple<List<TextRepresentable>, Map<String, Function<CommandSource, Text>>> createTextTemplateFragmentWithLinks(String message) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        if (message.isEmpty()) {
            return new Tuples.NullableTuple<ArrayList, Object>(Lists.newArrayList((Object[])new TextRepresentable[]{Text.EMPTY}), null);
        }
        Matcher m = this.enhancedUrlParser.matcher(message);
        if (!m.find()) {
            return new Tuples.NullableTuple<ArrayList, Object>(Lists.newArrayList((Object[])new TextRepresentable[]{TextParsingUtils.oldLegacy(message)}), null);
        }
        HashMap args = Maps.newHashMap();
        ArrayList texts = Lists.newArrayList();
        String remaining = message;
        StyleTuple st = EMPTY;
        do {
            String msg;
            String url;
            String[] textArray = remaining.split(this.enhancedUrlParser.pattern(), 2);
            Text first = Text.builder().color(st.colour).style(new TextStyle[]{st.style}).append(new Text[]{TextParsingUtils.oldLegacy(textArray[0])}).build();
            texts.add(first);
            remaining = textArray.length == 2 ? textArray[1] : null;
            String colourMatch = m.group("colour");
            if (colourMatch != null && !colourMatch.isEmpty()) {
                TextStyle reset = TextStyles.NONE;
                if (m.group("reset") != null) {
                    reset = TextStyles.RESET;
                }
                first = Text.of((Object[])new Object[]{reset, TextParsingUtils.oldLegacy(m.group("colour"))});
            }
            st = TextParsingUtils.getLastColourAndStyle((TextRepresentable)first, st);
            String whiteSpace = m.group("first");
            if (m.group("url") != null) {
                url = m.group("url");
                texts.add(TextParsingUtils.getTextForUrl(url, url, whiteSpace, st, m.group("options")));
                continue;
            }
            if (m.group("specialUrl") != null) {
                url = m.group("sUrl");
                msg = m.group("msg");
                texts.add(TextParsingUtils.getTextForUrl(url, msg, whiteSpace, st, m.group("optionssurl")));
                continue;
            }
            String cmd = m.group("sCmd");
            msg = m.group("sMsg");
            String optionList = m.group("optionsscmd");
            if (cmd.contains("{{subject}}")) {
                String arg = UUID.randomUUID().toString();
                args.put(arg, cs -> {
                    String command = cmd.replace("{{subject}}", cs.getName());
                    return this.getCmd(msg, command, optionList, whiteSpace);
                });
                texts.add(TextTemplate.arg((String)arg).color(st.colour).style(st.style).build());
                continue;
            }
            texts.add(Text.of((Object[])new Object[]{st.colour, st.style, this.getCmd(msg, cmd, optionList, whiteSpace)}));
        } while (remaining != null && m.find());
        if (remaining != null) {
            Text.Builder tb = Text.builder().color(st.colour).style(new TextStyle[]{st.style}).append(new Text[]{TextSerializers.FORMATTING_CODE.deserialize(remaining)});
            if (remaining.matches("^\\s+&r.*")) {
                tb.style(new TextStyle[]{TextStyles.RESET});
            }
            texts.add(tb.build());
        }
        return new Tuples.NullableTuple<List<TextRepresentable>, Map<String, Function<CommandSource, Text>>>(texts, args);
    }

    private Text getCmd(String msg, String cmd, String optionList, String whiteSpace) {
        LiteralText.Builder textBuilder = Text.builder((String)msg).onClick((ClickAction)TextActions.runCommand((String)cmd)).onHover(this.setupHoverOnCmd(cmd, optionList));
        if (optionList != null && optionList.contains("s")) {
            textBuilder.onClick((ClickAction)TextActions.suggestCommand((String)cmd));
        }
        Text toAdd = textBuilder.build();
        if (!whiteSpace.isEmpty()) {
            toAdd = Text.join((Text[])new Text[]{Text.of((String)whiteSpace), toAdd});
        }
        return toAdd;
    }

    @Nullable
    private HoverAction<?> setupHoverOnCmd(String cmd, @Nullable String optionList) {
        if (optionList != null) {
            if (optionList.contains("h")) {
                return null;
            }
            if (optionList.contains("s")) {
                return TextActions.showText((Text)this.getMessage("chat.command.clicksuggest", cmd));
            }
        }
        return TextActions.showText((Text)this.getMessage("chat.command.click", cmd));
    }

    private static Text getTextForUrl(String url, String msg, String whiteSpace, StyleTuple st, @Nullable String optionString) {
        String toParse = TextSerializers.FORMATTING_CODE.stripCodes(url);
        Nucleus plugin = Nucleus.getNucleus();
        try {
            URL urlObj = !toParse.startsWith("http://") && !toParse.startsWith("https://") ? new URL("http://" + toParse) : new URL(toParse);
            LiteralText.Builder textBuilder = Text.builder((String)msg).color(st.colour).style(new TextStyle[]{st.style}).onClick((ClickAction)TextActions.openUrl((URL)urlObj));
            if (optionString == null || !optionString.contains("h")) {
                textBuilder.onHover((HoverAction)TextActions.showText((Text)plugin.getMessageProvider().getTextMessageWithFormat("chat.url.click", url)));
            }
            if (!whiteSpace.isEmpty()) {
                return Text.builder((String)whiteSpace).append(new Text[]{textBuilder.build()}).build();
            }
            return textBuilder.build();
        }
        catch (MalformedURLException e) {
            plugin.getLogger().warn(plugin.getMessageProvider().getMessageWithFormat("chat.url.malformed", url));
            if (Nucleus.getNucleus().isDebugMode()) {
                e.printStackTrace();
            }
            LiteralText ret = Text.builder((String)url).color(st.colour).style(new TextStyle[]{st.style}).build();
            if (!whiteSpace.isEmpty()) {
                return Text.builder((String)whiteSpace).append(new Text[]{ret}).build();
            }
            return ret;
        }
    }

    public static Text joinTextsWithColoursFlowing(Text ... texts) {
        ArrayList result = Lists.newArrayList();
        Text last = null;
        for (Text n : texts) {
            if (last != null) {
                TextParsingUtils.getLastColourAndStyle(last, null).applyTo(x -> result.add(Text.of((Object[])new Object[]{x.colour, x.style, n})));
            } else {
                result.add(n);
            }
            last = n;
        }
        return Text.join((Iterable)result);
    }

    public static StyleTuple getLastColourAndStyle(TextRepresentable text, @Nullable StyleTuple current) {
        return TextParsingUtils.getLastColourAndStyle(text, current, TextColors.NONE, TextStyles.NONE);
    }

    public static StyleTuple getLastColourAndStyle(TextRepresentable text, @Nullable StyleTuple current, TextColor defaultColour, TextStyle defaultStyle) {
        List<Text> texts = TextParsingUtils.flatten(text.toText());
        if (texts.isEmpty()) {
            return current == null ? new StyleTuple(defaultColour, defaultStyle) : current;
        }
        TextColor tc = TextColors.NONE;
        TextStyle ts = texts.get(texts.size() - 1).getStyle();
        for (int i = texts.size() - 1; i > -1 && (tc = texts.get(i).getColor()) == TextColors.NONE; --i) {
        }
        if (tc == TextColors.NONE) {
            tc = defaultColour;
        }
        if (current == null) {
            return new StyleTuple(tc, ts);
        }
        return new StyleTuple(tc != TextColors.NONE ? tc : current.colour, ts);
    }

    private static List<Text> flatten(Text text) {
        ArrayList texts = Lists.newArrayList((Object[])new Text[]{text});
        if (!text.getChildren().isEmpty()) {
            text.getChildren().forEach(x -> texts.addAll(TextParsingUtils.flatten(x)));
        }
        return texts;
    }

    public Text addCommandToName(CommandSource p) {
        LiteralText.Builder text = Text.builder((String)p.getName());
        if (p instanceof User) {
            return this.addCommandToNameInternal((Text.Builder)text, (User)p);
        }
        return text.build();
    }

    public Text addCommandToDisplayName(CommandSource p) {
        Text name = this.getName(p);
        if (p instanceof User) {
            return this.addCommandToNameInternal(name, (User)p);
        }
        return name;
    }

    private Text addCommandToNameInternal(Text name, User user) {
        return this.addCommandToNameInternal(name.toBuilder(), user);
    }

    private Text addCommandToNameInternal(Text.Builder name, User user) {
        Text.Builder hoverAction;
        if (this.commandNameOnClick == null) {
            return name.build();
        }
        String commandToRun = this.commandNameOnClick.replace("{{subject}}", user.getName()).replace("{{player}}", user.getName());
        Optional ha = name.getHoverAction();
        if (ha.isPresent() && ha.get() instanceof HoverAction.ShowText) {
            HoverAction.ShowText h = (HoverAction.ShowText)ha.get();
            hoverAction = ((Text)h.getResult()).toBuilder();
            hoverAction.append(new Text[]{Text.NEW_LINE});
        } else {
            hoverAction = Text.builder();
        }
        hoverAction.append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("name.hover.command", commandToRun)});
        return name.onClick((ClickAction)TextActions.suggestCommand((String)commandToRun)).onHover((HoverAction)TextActions.showText((Text)hoverAction.toText())).build();
    }

    private Text getName(CommandSource cs) {
        if (cs instanceof Player) {
            return Nucleus.getNucleus().getNameUtil().getName((User)((Player)cs));
        }
        return Text.of((String)cs.getName());
    }

    @Override
    public void onReload() throws Exception {
        this.commandNameOnClick = ((CoreConfig)this.getServiceUnchecked(CoreConfigAdapter.class).getNodeOrDefault()).getCommandOnNameClick();
        if (this.commandNameOnClick == null || this.commandNameOnClick.isEmpty()) {
            return;
        }
        if (!this.commandNameOnClick.startsWith("/")) {
            this.commandNameOnClick = "/" + this.commandNameOnClick;
        }
        if (!this.commandNameOnClick.endsWith(" ")) {
            this.commandNameOnClick = this.commandNameOnClick + " ";
        }
    }

    @NonnullByDefault
    public static final class StyleTuple {
        public final TextColor colour;
        public final TextStyle style;

        StyleTuple(TextColor colour, TextStyle style) {
            this.colour = colour;
            this.style = style;
        }

        void applyTo(Consumer<StyleTuple> consumer) {
            consumer.accept(this);
        }

        Text getTextOf() {
            Text.Builder tb = Text.builder();
            if (this.colour != TextColors.NONE) {
                tb.color(this.colour);
            }
            tb.style(new TextStyle[]{this.style});
            return tb.toText();
        }
    }
}

