/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.traits;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import java.util.Locale;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;

public interface MessageProviderTrait {
    default public MessageProvider getMessageProvider() {
        return Nucleus.getNucleus().getMessageProvider();
    }

    default public String getMessageString(String key, String ... replacements) {
        return this.getMessageProvider().getMessageWithFormat(key, replacements);
    }

    default public Text getMessage(String key) {
        return this.getMessageProvider().getTextMessageWithFormat(key, new String[0]);
    }

    default public Text getMessage(String key, String ... replacements) {
        return this.getMessageProvider().getTextMessageWithFormat(key, replacements);
    }

    default public Text getMessage(String key, Text ... replacements) {
        return this.getMessageProvider().getTextMessageWithTextFormat(key, replacements);
    }

    default public Text getMessage(String key, Object ... replacements) {
        return this.getMessageProvider().getTextMessageWithFormat(key, replacements);
    }

    default public Text getMessageFor(Locale locale, String key) {
        return this.getMessage(key);
    }

    default public Text getMessageFor(Locale locale, String key, Object ... replacements) {
        return this.getMessage(key, replacements);
    }

    default public Text getMessageFor(Locale locale, String key, Text ... replacements) {
        return this.getMessage(key, replacements);
    }

    default public Text getMessageFor(Locale locale, String key, String ... replacements) {
        return this.getMessage(key, replacements);
    }

    default public Text getMessageFor(CommandSource source, String key) {
        return this.getMessageFor(source.getLocale(), key);
    }

    default public Text getMessageFor(CommandSource source, String key, Object ... replacements) {
        return this.getMessageFor(source.getLocale(), key, replacements);
    }

    default public Text getMessageFor(CommandSource source, String key, Text ... replacements) {
        return this.getMessageFor(source.getLocale(), key, replacements);
    }

    default public Text getMessageFor(CommandSource source, String key, String ... replacements) {
        return this.getMessageFor(source.getLocale(), key, replacements);
    }

    default public void sendMessageTo(CommandSource receiver, String key) {
        receiver.sendMessage(this.getMessageFor(receiver.getLocale(), key));
    }

    default public void sendMessageTo(CommandSource receiver, String key, Object ... replacements) {
        receiver.sendMessage(this.getMessageFor(receiver.getLocale(), key, replacements));
    }

    default public void sendMessageTo(CommandSource receiver, String key, Text ... replacements) {
        receiver.sendMessage(this.getMessageFor(receiver.getLocale(), key, replacements));
    }

    default public void sendMessageTo(CommandSource receiver, String key, String ... replacements) {
        receiver.sendMessage(this.getMessageFor(receiver.getLocale(), key, replacements));
    }
}

