/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ban.commands;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.ban.Ban;
import org.spongepowered.api.util.ban.BanTypes;

@RegisterCommand(value={"ban"})
@Permissions(suggestedLevel=SuggestedLevel.MOD)
@NoModifiers
@EssentialsEquivalent(value={"ban"})
@NonnullByDefault
public class BanCommand
extends AbstractCommand<CommandSource> {
    static final String notifyPermission = "nucleus.ban.notify";
    private final String name = "name";

    @Override
    public Map<String, PermissionInformation> permissionsToRegister() {
        HashMap ps = Maps.newHashMap();
        ps.put(notifyPermission, PermissionInformation.getWithTranslation("permission.ban.notify", SuggestedLevel.MOD));
        return ps;
    }

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("offline", PermissionInformation.getWithTranslation("permission.ban.offline", SuggestedLevel.MOD));
        m.put("exempt.target", PermissionInformation.getWithTranslation("permission.tempban.exempt.target", SuggestedLevel.MOD));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{NucleusParameters.ONE_GAME_PROFILE_UUID, NucleusParameters.ONE_GAME_PROFILE, GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)this.name)))}), GenericArguments.optionalWeak((CommandElement)NucleusParameters.REASON)};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        String r = args.getOne("reason").orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("ban.defaultreason", new String[0]));
        Optional<GameProfile> ou = Optional.ofNullable(args.getOne("user uuid").orElseGet(() -> args.getOne("user").orElse(null)));
        if (ou.isPresent()) {
            Optional optionalUser = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(ou.get());
            if (!(optionalUser.isPresent() && ((User)optionalUser.get()).isOnline() || this.permissions.testSuffix((Subject)src, "offline"))) {
                throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.ban.offline.noperms", new String[0]));
            }
            if (optionalUser.isPresent() && this.permissions.testSuffix((Subject)optionalUser.get(), "exempt.target", src, false)) {
                throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.ban.exempt", ((User)optionalUser.get()).getName()));
            }
            return this.executeBan(src, ou.get(), r);
        }
        if (!this.permissions.testSuffix((Subject)src, "offline")) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.ban.offline.noperms", new String[0]));
        }
        String userToFind = (String)args.getOne(this.name).get();
        Sponge.getScheduler().createAsyncExecutor((Object)Nucleus.getNucleus()).execute(() -> {
            GameProfileManager gpm = Sponge.getServer().getGameProfileManager();
            try {
                GameProfile gp = (GameProfile)gpm.get(userToFind).get();
                Sponge.getScheduler().createSyncExecutor((Object)Nucleus.getNucleus()).execute(() -> {
                    UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
                    User user = uss.getOrCreate(gp);
                    src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("gameprofile.new", user.getName()));
                    try {
                        this.executeBan(src, gp, r);
                    }
                    catch (Exception e) {
                        Nucleus.getNucleus().printStackTraceIfDebugMode(e);
                    }
                });
            }
            catch (Exception e) {
                Nucleus.getNucleus().printStackTraceIfDebugMode(e);
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.ban.profileerror", userToFind));
            }
        });
        return CommandResult.empty();
    }

    private CommandResult executeBan(CommandSource src, GameProfile u, String r) {
        BanService service = (BanService)Sponge.getServiceManager().provideUnchecked(BanService.class);
        UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
        User user = (User)uss.get(u).get();
        if (!user.isOnline() && !this.permissions.testSuffix((Subject)src, "offline")) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.ban.offline.noperms", new String[0]));
            return CommandResult.empty();
        }
        if (service.isBanned(u)) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.ban.alreadyset", u.getName().orElse(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0]))));
            return CommandResult.empty();
        }
        Ban bp = Ban.builder().type(BanTypes.PROFILE).profile(u).source(src).reason(TextSerializers.FORMATTING_CODE.deserialize(r)).build();
        service.addBan(bp);
        MutableMessageChannel send = new PermissionMessageChannel(notifyPermission).asMutable();
        send.addMember((MessageReceiver)src);
        send.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.ban.applied", u.getName().orElse(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0])), src.getName()));
        send.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("standard.reasoncoloured", r));
        if (Sponge.getServer().getPlayer(u.getUniqueId()).isPresent()) {
            ((Player)Sponge.getServer().getPlayer(u.getUniqueId()).get()).kick(TextSerializers.FORMATTING_CODE.deserialize(r));
        }
        return CommandResult.success();
    }
}

