/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.environment.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.dataservices.loaders.WorldDataManager;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularWorldService;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.modules.environment.datamodule.EnvironmentWorldDataModule;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions
@RunAsync
@RegisterCommand(value={"lockweather", "killweather"})
@NoModifiers
@NonnullByDefault
public class LockWeatherCommand
extends AbstractCommand<CommandSource> {
    private final WorldDataManager loader = Nucleus.getNucleus().getWorldDataManager();
    private final String worldKey = "world";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.optionalWeak((CommandElement)GenericArguments.world((Text)Text.of((String)this.worldKey)))), NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        Optional<WorldProperties> world = this.getWorldProperties(src, this.worldKey, args);
        if (!world.isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.specifyworld", new String[0]));
            return CommandResult.empty();
        }
        WorldProperties wp = world.get();
        Optional<ModularWorldService> ws = this.loader.getWorld(wp.getUniqueId());
        if (!ws.isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.noworld", wp.getWorldName()));
            return CommandResult.empty();
        }
        EnvironmentWorldDataModule environmentWorldDataModule = ws.get().get(EnvironmentWorldDataModule.class);
        boolean toggle = args.getOne("true|false").orElse(!environmentWorldDataModule.isLockWeather());
        environmentWorldDataModule.setLockWeather(toggle);
        ws.get().set(environmentWorldDataModule);
        if (toggle) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.lockweather.locked", wp.getWorldName()));
        } else {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.lockweather.unlocked", wp.getWorldName()));
        }
        return CommandResult.success();
    }
}

