/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Home;
import io.github.nucleuspowered.nucleus.api.nucleusdata.NamedLocation;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.home.commands.HomeCommand;
import io.github.nucleuspowered.nucleus.modules.home.commands.HomeOtherCommand;
import io.github.nucleuspowered.nucleus.modules.home.services.HomeHandler;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(prefix="home", mainOverride="list", suggestedLevel=SuggestedLevel.USER)
@RunAsync
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"list"}, subcommandOf=HomeCommand.class, rootAliasRegister={"listhomes", "homes"})
public class ListHomeCommand
extends AbstractCommand<CommandSource> {
    private final String exempt = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(HomeOtherCommand.class).getPermissionWithSuffix("exempt.target");
    private final HomeHandler homeHandler = (HomeHandler)this.getServiceUnchecked(HomeHandler.class);

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("others", PermissionInformation.getWithTranslation("permission.others", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optional((CommandElement)this.requirePermissionArg(NucleusParameters.ONE_USER, this.permissions.getPermissionWithSuffix("others")))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        boolean other;
        User user = this.getUserFromArgs(User.class, src, "user", args);
        boolean bl = other = src instanceof User && !((User)src).getUniqueId().equals(user.getUniqueId());
        if (other && this.hasPermission((Subject)user, this.exempt)) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.listhome.exempt", new String[0]));
        }
        List<Home> msw = this.homeHandler.getHomes(user);
        if (msw.isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.home.nohomes", new String[0]));
            return CommandResult.empty();
        }
        Text header = other ? Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("home.title.name", user.getName()) : Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("home.title.normal", new String[0]);
        List lt = msw.stream().sorted(Comparator.comparing(NamedLocation::getName)).map(x -> {
            Optional<Location<World>> olw = x.getLocation();
            if (!olw.isPresent()) {
                return Text.builder().append(new Text[]{Text.builder((String)x.getName()).color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("home.warphoverinvalid", x.getName()))).build()}).build();
            }
            Location<World> lw = olw.get();
            return Text.builder().append(new Text[]{Text.builder((String)x.getName()).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.UNDERLINE}).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("home.warphover", x.getName()))).onClick((ClickAction)TextActions.runCommand((String)(other ? "/homeother " + user.getName() + " " + x.getName() : "/home " + x.getName()))).build()}).append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("home.location", ((World)lw.getExtent()).getName(), String.valueOf(lw.getBlockX()), String.valueOf(lw.getBlockY()), String.valueOf(lw.getBlockZ()))}).build();
        }).collect(Collectors.toList());
        PaginationList.Builder pb = Util.getPaginationBuilder(src).title(Text.of((Object[])new Object[]{TextColors.YELLOW, header})).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents(lt);
        pb.sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

