/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.info.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.TextFileController;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.info.config.InfoConfig;
import io.github.nucleuspowered.nucleus.modules.info.config.InfoConfigAdapter;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.USER)
@RunAsync
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"motd"})
@EssentialsEquivalent(value={"motd"})
public class MotdCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private Text title = Text.EMPTY;
    private boolean usePagination = true;

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        Optional<TextFileController> otfc = Nucleus.getNucleus().getTextFileController("motd");
        if (!otfc.isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.motd.nocontroller", new String[0]));
            return CommandResult.empty();
        }
        if (this.usePagination) {
            otfc.get().sendToPlayer(src, this.title);
        } else {
            otfc.get().getTextFromNucleusTextTemplates(src).forEach(arg_0 -> ((CommandSource)src).sendMessage(arg_0));
        }
        return CommandResult.success();
    }

    @Override
    public void onReload() {
        InfoConfig config = (InfoConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(InfoConfigAdapter.class).getNodeOrDefault();
        String title = config.getMotdTitle();
        this.title = title.isEmpty() ? Text.EMPTY : TextSerializers.FORMATTING_CODE.deserialize(title);
        this.usePagination = config.isMotdUsePagination();
    }
}

