/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.info.listeners;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.info.commands.MotdCommand;
import io.github.nucleuspowered.nucleus.modules.info.config.InfoConfig;
import io.github.nucleuspowered.nucleus.modules.info.config.InfoConfigAdapter;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.IncorrectAdapterTypeException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.NoModuleException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public class InfoListener
implements Reloadable,
ListenerBase.Conditional {
    private final String motdPerm = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(MotdCommand.class).getPermissionWithSuffix("login");
    private boolean usePagination = true;
    private Text title = Text.EMPTY;
    private int delay = 500;

    @Listener
    public void playerJoin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        Sponge.getScheduler().createAsyncExecutor((Object)Nucleus.getNucleus()).schedule(() -> {
            if (this.hasPermission((Subject)player, this.motdPerm)) {
                Nucleus.getNucleus().getTextFileController("motd").ifPresent(x -> {
                    if (this.usePagination) {
                        x.sendToPlayer((CommandSource)player, this.title);
                    } else {
                        x.getTextFromNucleusTextTemplates((CommandSource)player).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
                    }
                });
            }
        }, (long)this.delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public Map<String, PermissionInformation> getPermissions() {
        HashMap msp = Maps.newHashMap();
        msp.put(this.motdPerm, PermissionInformation.getWithTranslation("permission.motd.join", SuggestedLevel.USER));
        return msp;
    }

    @Override
    public void onReload() {
        InfoConfig config = (InfoConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(InfoConfigAdapter.class).getNodeOrDefault();
        this.delay = (int)(config.getMotdDelay() * 1000.0f);
        this.usePagination = config.isMotdUsePagination();
        String title = config.getMotdTitle();
        this.title = title.isEmpty() ? Text.EMPTY : TextSerializers.FORMATTING_CODE.deserialize(title);
    }

    @Override
    public boolean shouldEnable() {
        try {
            return ((InfoConfig)Nucleus.getNucleus().getModuleContainer().getConfigAdapterForModule("info", InfoConfigAdapter.class).getNodeOrDefault()).isShowMotdOnJoin();
        }
        catch (IncorrectAdapterTypeException | NoModuleException e) {
            if (Nucleus.getNucleus().isDebugMode()) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

