/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.servershop.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.argumentparsers.ItemAliasArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.configurate.datatypes.ItemDataNode;
import io.github.nucleuspowered.nucleus.dataservices.ItemDataService;
import io.github.nucleuspowered.nucleus.internal.EconHelper;
import io.github.nucleuspowered.nucleus.internal.annotations.RequiresEconomy;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.servershop.config.ServerShopConfig;
import io.github.nucleuspowered.nucleus.modules.servershop.config.ServerShopConfigAdapter;
import java.util.Collection;
import java.util.function.Consumer;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TranslatableText;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@NoModifiers
@RequiresEconomy
@Permissions(suggestedLevel=SuggestedLevel.USER)
@RegisterCommand(value={"itembuy", "buy"})
@EssentialsEquivalent(value={"buy"})
@NonnullByDefault
public class BuyCommand
extends AbstractCommand<Player>
implements Reloadable {
    private final ItemDataService itemDataService = Nucleus.getNucleus().getItemDataService();
    private final EconHelper econHelper = Nucleus.getNucleus().getEconHelper();
    private final String itemKey = "item";
    private final String amountKey = "amount";
    private int max;

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"y", "f", "a", "-yes", "-auto"}).buildWith(GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.onlyOne((CommandElement)new ItemAliasArgument((Text)Text.of((String)this.itemKey))), GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.amountKey)))}))};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) {
        CatalogType ct = (CatalogType)args.getOne(this.itemKey).get();
        int amount = (Integer)args.getOne(this.amountKey).get();
        ItemDataNode node = this.itemDataService.getDataForItem(ct.getId());
        if (node.getServerBuyPrice() < 0.0) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.itembuy.notforsale", new String[0]));
            return CommandResult.empty();
        }
        if (amount > this.max) {
            amount = this.max;
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.itembuy.maximum", String.valueOf(amount)));
        }
        ItemStack created = ct instanceof ItemType ? ItemStack.of((ItemType)((ItemType)ct), (int)amount) : ItemStack.builder().fromBlockState((BlockState)ct).quantity(amount).build();
        double perUnitCost = node.getServerBuyPrice();
        int unitCount = amount;
        double overallCost = perUnitCost * (double)unitCount;
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.itembuy.summary", new Text[]{Text.of((String)String.valueOf(amount)), Text.of((Translatable)created, (Object[])new Object[0]), Text.of((String)this.econHelper.getCurrencySymbol(overallCost))}));
        if (args.hasAny("y")) {
            new BuyCallback(src, overallCost, created, unitCount, perUnitCost).accept((CommandSource)src);
        } else {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.itembuy.clickhere", new String[0]).toBuilder().onClick((ClickAction)TextActions.executeCallback((Consumer)new BuyCallback(src, overallCost, created, unitCount, perUnitCost))).build());
        }
        return CommandResult.success();
    }

    @Override
    public void onReload() {
        this.max = ((ServerShopConfig)((ServerShopConfigAdapter)this.getServiceUnchecked(ServerShopConfigAdapter.class)).getNodeOrDefault()).getMaxPurchasableAtOnce();
    }

    private class BuyCallback
    implements Consumer<CommandSource> {
        private final Player src;
        private final double overallCost;
        private final ItemStack created;
        private final int unitCount;
        private final double perUnitCost;
        private boolean hasRun = false;

        private BuyCallback(Player src, double overallCost, ItemStack created, int unitCount, double perUnitCost) {
            this.src = src;
            this.overallCost = overallCost;
            this.created = created;
            this.unitCount = unitCount;
            this.perUnitCost = perUnitCost;
        }

        @Override
        public void accept(CommandSource source) {
            if (this.hasRun) {
                return;
            }
            this.hasRun = true;
            Inventory target = Util.getStandardInventory((Carrier)this.src);
            if (BuyCommand.this.econHelper.withdrawFromPlayer(this.src, this.overallCost, false)) {
                TranslatableText name = Text.of((Translatable)this.created, (Object[])new Object[0]);
                InventoryTransactionResult itr = target.offer(this.created);
                if (itr.getRejectedItems().isEmpty()) {
                    this.src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.itembuy.transactionsuccess", new Text[]{Text.of((Object[])new Object[]{this.unitCount}), name, Text.of((String)BuyCommand.this.econHelper.getCurrencySymbol(this.overallCost))}));
                } else {
                    Collection iss = itr.getRejectedItems();
                    int rejected = iss.stream().mapToInt(ItemStackSnapshot::getQuantity).sum();
                    double refund = (double)rejected * this.perUnitCost;
                    BuyCommand.this.econHelper.depositInPlayer((User)this.src, refund, false);
                    this.src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.itembuy.transactionpartial", new Text[]{Text.of((Object[])new Object[]{rejected}), name}));
                    this.src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.itembuy.transactionsuccess", new Text[]{Text.of((String)String.valueOf(this.unitCount - rejected)), name, Text.of((String)BuyCommand.this.econHelper.getCurrencySymbol(this.overallCost - refund))}));
                }
            } else {
                this.src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.itembuy.nofunds", new String[0]));
            }
        }
    }
}

