/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.commands;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.CommandFlags;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions(prefix="teleport", supportsOthers=true)
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"tppos"})
@EssentialsEquivalent(value={"tppos"})
public class TeleportPositionCommand
extends AbstractCommand<CommandSource> {
    private final String location = "world";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().setUnknownShortFlagBehavior(CommandFlags.UnknownFlagBehavior.IGNORE).flag(new String[]{"f", "-force"}).flag(new String[]{"c", "-chunk"}).permissionFlag(this.permissions.getPermissionWithSuffix("exempt.bordercheck"), new String[]{"b", "-border"}).buildWith(GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.optionalWeak((CommandElement)this.requirePermissionArg(NucleusParameters.ONE_PLAYER, this.permissions.getOthers())), GenericArguments.onlyOne((CommandElement)GenericArguments.optionalWeak((CommandElement)GenericArguments.world((Text)Text.of((String)this.location)))), NucleusParameters.POSITION}))};
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        return new HashMap<String, PermissionInformation>(){
            {
                this.put("exempt.bordercheck", PermissionInformation.getWithTranslation("permission.tppos.border", SuggestedLevel.ADMIN));
            }
        };
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        NucleusTeleportHandler.TeleportResult result;
        Player pl = this.getUserFromArgs(Player.class, src, "player", args);
        WorldProperties wp = args.getOne(this.location).orElse(pl.getWorld().getProperties());
        World world = (World)Sponge.getServer().loadWorld(wp.getUniqueId()).get();
        Vector3d location = (Vector3d)args.getOne("x y z").get();
        double xx = location.getX();
        double zz = location.getZ();
        double yy = location.getY();
        if (yy < 0.0) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tppos.ysmall", new String[0]));
            return CommandResult.empty();
        }
        if (args.hasAny("c")) {
            xx = xx * 16.0 + 8.0;
            yy = yy * 16.0 + 8.0;
            zz = zz * 16.0 + 8.0;
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tppos.fromchunk", String.valueOf(xx), String.valueOf(yy), String.valueOf(zz)));
        }
        Vector3i max = world.getBlockMax();
        Vector3i min = world.getBlockMin();
        if (!(this.isBetween(xx, max.getX(), min.getX()) && this.isBetween(yy, max.getY(), min.getY()) && this.isBetween(zz, max.getZ(), min.getZ()))) {
            throw ReturnMessageException.fromKey("command.tppos.invalid", new Object[0]);
        }
        Location loc = new Location((Extent)world, xx, yy, zz);
        NucleusTeleportHandler teleportHandler = Nucleus.getNucleus().getTeleportHandler();
        if (args.getOne("f").orElse(false).booleanValue()) {
            if (teleportHandler.teleportPlayer(pl, (Location<World>)loc, pl.getRotation(), NucleusTeleportHandler.StandardTeleportMode.NO_CHECK, cause, false, !args.hasAny("b")).isSuccess()) {
                pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tppos.success.self", new String[0]));
                if (!src.equals(pl)) {
                    src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tppos.success.other", pl.getName()));
                }
                return CommandResult.success();
            }
            throw ReturnMessageException.fromKey("command.tppos.cancelledevent", new Object[0]);
        }
        NucleusTeleportHandler.StandardTeleportMode mode = teleportHandler.getTeleportModeForPlayer(pl);
        if (args.hasAny("c") && mode == NucleusTeleportHandler.StandardTeleportMode.FLYING_THEN_SAFE) {
            mode = NucleusTeleportHandler.StandardTeleportMode.FLYING_THEN_SAFE_CHUNK;
        }
        if ((result = teleportHandler.teleportPlayer(pl, (Location<World>)loc, pl.getRotation(), mode, cause, true, !args.hasAny("b"))).isSuccess()) {
            pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tppos.success.self", new String[0]));
            if (!src.equals(pl)) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tppos.success.other", pl.getName()));
            }
            return CommandResult.success();
        }
        if (result == NucleusTeleportHandler.TeleportResult.FAILED_NO_LOCATION) {
            throw ReturnMessageException.fromKey("command.tppos.nosafe", new Object[0]);
        }
        throw ReturnMessageException.fromKey("command.tppos.cancelledevent", new Object[0]);
    }

    private boolean isBetween(double toCheck, double max, double min) {
        return toCheck >= min && toCheck <= max;
    }
}

