/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warn.events;

import io.github.nucleuspowered.nucleus.api.events.NucleusWarnEvent;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public abstract class WarnEvent
extends AbstractEvent
implements NucleusWarnEvent {
    private final Cause cause;
    private final User targetUser;
    private final String reason;

    private WarnEvent(Cause cause, User targetUser, String reason) {
        this.cause = cause;
        this.targetUser = targetUser;
        this.reason = reason;
    }

    public User getTargetUser() {
        return this.targetUser;
    }

    public Cause getCause() {
        return this.cause;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public static class Expire
    extends WarnEvent
    implements NucleusWarnEvent.Expired {
        @Nullable
        private final UUID warner;

        public Expire(Cause cause, User targetUser, String reason, @Nullable UUID warner) {
            super(cause, targetUser, reason);
            this.warner = warner;
        }

        @Override
        public Optional<UUID> getWarner() {
            return Optional.ofNullable(this.warner);
        }
    }

    public static class Warned
    extends WarnEvent
    implements NucleusWarnEvent.Warned {
        @Nullable
        private final Duration expiration;

        public Warned(Cause cause, User targetUser, String reason, @Nullable Duration expiration) {
            super(cause, targetUser, reason);
            this.expiration = expiration;
        }

        @Override
        public Optional<Duration> getTimeUntilExpiration() {
            return Optional.ofNullable(this.expiration);
        }
    }
}

