/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.modules.warp.commands.WarpCommand;
import io.github.nucleuspowered.nucleus.modules.warp.event.CreateWarpEvent;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.regex.Pattern;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(prefix="warp")
@RegisterCommand(value={"set"}, subcommandOf=WarpCommand.class, rootAliasRegister={"setwarp", "warpset"})
@EssentialsEquivalent(value={"setwarp", "createwarp"})
@NonnullByDefault
public class SetWarpCommand
extends AbstractCommand<Player> {
    private final WarpHandler qs = (WarpHandler)this.getServiceUnchecked(WarpHandler.class);
    private final Pattern warpRegex = Pattern.compile("^[A-Za-z][A-Za-z0-9]{0,25}$");

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"warp")))};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        String warp = (String)args.getOne("warp").get();
        if (!this.warpRegex.matcher(warp).matches()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.invalidname", new String[0]));
            return CommandResult.empty();
        }
        if (this.qs.getWarp(warp).isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.nooverwrite", new String[0]));
            return CommandResult.empty();
        }
        CreateWarpEvent event = CauseStackHelper.createFrameWithCausesWithReturn(c -> new CreateWarpEvent((Cause)c, warp, (Location<World>)src.getLocation()), src);
        if (Sponge.getEventManager().post((Event)event)) {
            throw new ReturnMessageException(event.getCancelMessage().orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("nucleus.eventcancelled", new String[0])));
        }
        if (this.qs.setWarp(warp, (Location<World>)src.getLocation(), src.getRotation())) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.set", warp));
            return CommandResult.success();
        }
        throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.seterror", new String[0]));
    }
}

