/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands.border;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.modules.world.commands.border.BorderCommand;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions(prefix="world.border", mainOverride="set")
@NoModifiers
@RegisterCommand(value={"reset"}, subcommandOf=BorderCommand.class)
@NonnullByDefault
public class ResetBorderCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_WORLD_PROPERTIES_ALL};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        WorldProperties wp = this.getWorldFromUserOrArgs(src, "world", args);
        wp.setWorldBorderCenter(0.0, 0.0);
        Optional world = Sponge.getServer().getWorld(wp.getUniqueId());
        World toDiameter = world.orElseGet(() -> (World)Sponge.getServer().getWorld(((WorldProperties)Sponge.getServer().getDefaultWorld().orElseThrow(IllegalStateException::new)).getUniqueId()).orElseThrow(IllegalStateException::new));
        long diameter = Math.abs(toDiameter.getBiomeMax().getX() - toDiameter.getBiomeMin().getX()) + 1;
        wp.setWorldBorderDiameter((double)diameter);
        world.ifPresent(w -> {
            w.getWorldBorder().setCenter(0.0, 0.0);
            w.getWorldBorder().setDiameter((double)diameter);
        });
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.setborder.set", wp.getWorldName(), "0", "0", String.valueOf(diameter)));
        return CommandResult.success();
    }
}

