/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.util;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.util.Tuple;

public final class TypeHelper {
    private TypeHelper() {
    }

    public static Tuple<DataQuery, List<?>> getList(DataQuery query, Object array) {
        if (array instanceof byte[]) {
            return Tuple.of((Object)TypeHelper.getNewName(query, "B"), Arrays.asList(ArrayUtils.toObject((byte[])((byte[])array))));
        }
        if (array instanceof short[]) {
            return Tuple.of((Object)TypeHelper.getNewName(query, "S"), Arrays.asList(ArrayUtils.toObject((short[])((short[])array))));
        }
        if (array instanceof int[]) {
            return Tuple.of((Object)TypeHelper.getNewName(query, "I"), Arrays.asList(ArrayUtils.toObject((int[])((int[])array))));
        }
        if (array instanceof long[]) {
            return Tuple.of((Object)TypeHelper.getNewName(query, "J"), Arrays.asList(ArrayUtils.toObject((long[])((long[])array))));
        }
        if (array instanceof float[]) {
            return Tuple.of((Object)TypeHelper.getNewName(query, "F"), Arrays.asList(ArrayUtils.toObject((float[])((float[])array))));
        }
        if (array instanceof double[]) {
            return Tuple.of((Object)TypeHelper.getNewName(query, "D"), Arrays.asList(ArrayUtils.toObject((double[])((double[])array))));
        }
        if (array instanceof boolean[]) {
            return Tuple.of((Object)TypeHelper.getNewName(query, "Z"), Arrays.asList(ArrayUtils.toObject((boolean[])((boolean[])array))));
        }
        throw new RuntimeException();
    }

    public static Tuple<DataQuery, Object> getArray(DataQuery query, DataView container) {
        String a = query.asString(".");
        DataQuery q = DataQuery.of((char)'.', (String)query.asString(".").replaceAll("\\$Array\\$[a-zA-Z]$", ""));
        String objType = a.substring(a.length() - 1);
        List array = container.getList(query).orElse(Lists.newArrayList());
        int size = array.size();
        switch (objType) {
            case "B": {
                byte[] b = new byte[size];
                for (int i = 0; i < size; ++i) {
                    Object obj = array.get(i);
                    b[i] = obj instanceof String ? Byte.parseByte((String)obj) : ((Number)obj).byteValue();
                }
                return Tuple.of((Object)q, (Object)b);
            }
            case "S": {
                short[] b = new short[size];
                for (int i = 0; i < size; ++i) {
                    Object obj = array.get(i);
                    b[i] = obj instanceof String ? Short.parseShort((String)obj) : ((Number)obj).shortValue();
                }
                return Tuple.of((Object)q, (Object)b);
            }
            case "I": {
                int[] b = new int[size];
                for (int i = 0; i < size; ++i) {
                    Object obj = array.get(i);
                    b[i] = obj instanceof String ? Integer.parseInt((String)obj) : ((Number)obj).intValue();
                }
                return Tuple.of((Object)q, (Object)b);
            }
            case "J": {
                long[] b = new long[size];
                for (int i = 0; i < size; ++i) {
                    Object obj = array.get(i);
                    b[i] = obj instanceof String ? Long.parseLong((String)obj) : ((Number)obj).longValue();
                }
                return Tuple.of((Object)q, (Object)b);
            }
            case "F": {
                float[] b = new float[size];
                for (int i = 0; i < size; ++i) {
                    Object obj = array.get(i);
                    b[i] = obj instanceof String ? Float.parseFloat((String)obj) : ((Number)obj).floatValue();
                }
                return Tuple.of((Object)q, (Object)b);
            }
            case "D": {
                double[] b = new double[size];
                for (int i = 0; i < size; ++i) {
                    Object obj = array.get(i);
                    b[i] = obj instanceof String ? Double.parseDouble((String)obj) : ((Number)obj).doubleValue();
                }
                return Tuple.of((Object)q, (Object)b);
            }
            case "Z": {
                boolean[] b = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    Object obj = array.get(i);
                    b[i] = obj instanceof String ? Boolean.parseBoolean((String)obj) : (Boolean)obj;
                }
                return Tuple.of((Object)q, (Object)b);
            }
        }
        throw new RuntimeException();
    }

    private static DataQuery getNewName(DataQuery dataQuery, String name) {
        return DataQuery.of((char)'.', (String)(dataQuery.asString(".") + "$Array$" + name));
    }
}

