/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.recipes;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.crafting.ICraftingRecipeList;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.block.machine.low.TileEntityCompressor;
import ic2.core.block.machine.low.TileEntityMacerator;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import trinsdar.ic2c_extras.blocks.tileentity.TileEntityExtruder;
import trinsdar.ic2c_extras.blocks.tileentity.TileEntityFluidCanningMachine;
import trinsdar.ic2c_extras.blocks.tileentity.TileEntityMetalBender;
import trinsdar.ic2c_extras.blocks.tileentity.TileEntityOreWashingPlant;
import trinsdar.ic2c_extras.blocks.tileentity.TileEntityRoller;
import trinsdar.ic2c_extras.blocks.tileentity.TileEntityThermalCentrifuge;
import trinsdar.ic2c_extras.recipes.Ic2cExtrasRecipes;
import trinsdar.ic2c_extras.util.Registry;

public class MachineRecipes {
    static ICraftingRecipeList recipes = ClassicRecipes.advCrafting;

    public static void init() {
        MachineRecipes.initMachineRecipes();
        MachineRecipes.initFurnaceRecipes();
        MachineRecipes.initReplaceMaceratorRecipes();
    }

    public static void postInit() {
        HashSet<String> crushedBlacklist = new HashSet<String>();
        HashSet<String> crushedPurifiedBlackList = new HashSet<String>();
        HashSet<String> plateBlacklist = new HashSet<String>();
        HashSet<String> ingotBlacklist = new HashSet<String>();
        HashSet ingotGTBlacklist = new HashSet();
        HashSet<String> gemBlacklist = new HashSet<String>();
        HashSet<String> ingotBmeMmeBlacklist = new HashSet<String>();
        crushedBlacklist.addAll(Arrays.asList("crushedIron", "crushedGold", "crushedSilver", "crushedLead", "crushedCopper", "crushedTin", "crushedUranium"));
        crushedPurifiedBlackList.addAll(Arrays.asList("crushedPurifiedIron", "crushedPurifiedGold", "crushedPurifiedSilver", "crushedPurifiedLead", "crushedPurifiedCopper", "crushedPurifiedTin", "crushedPurifiedUranium"));
        plateBlacklist.addAll(Arrays.asList("plateIron", "plateGold", "plateSilver", "plateLead", "plateCopper", "plateTin", "plateRefinedIron", "plateSteel", "plateBronze"));
        ingotBlacklist.addAll(Arrays.asList("ingotIron", "ingotGold", "ingotSilver", "ingotLead", "ingotCopper", "ingotTin", "ingotRefinedIron", "ingotSteel", "ingotBronze"));
        gemBlacklist.addAll(Arrays.asList("ingotDiamond", "ingotEmerald", "ingotQuartz", "ingotIridium", "ingotCoal", "ingotRedstone"));
        if (Loader.isModLoaded((String)"basemetals")) {
            plateBlacklist.addAll(Arrays.asList("plateAdamantine", "plateAntimony", "plateBismuth", "plateColdiron", "plateNickel", "platePlatinum", "plateStarsteel", "plateZinc"));
            ingotBmeMmeBlacklist.addAll(Arrays.asList("ingotAdamantine", "ingotAntimony", "ingotBismuth", "ingotColdiron", "ingotNickel", "ingotPlatinum", "ingotStarsteel", "ingotZinc"));
        }
        if (Loader.isModLoaded((String)"modernmetals")) {
            plateBlacklist.addAll(Arrays.asList("plateAluminum", "plateAluminium", "plateAluminumbrass", "plateAluminiumbrass", "plateBeryllium", "plateBoron", "plateCadmium", "plateChrome", "plateChromium", "plateGalvanizedsteel", "plateIridium", "plateMagnesium", "plateManganese", "plateNichrome", "plateOsmium", "platePlutonium", "plateRutile", "plateStainlesssteel", "plateTantalum", "plateTitanium", "plateThorium", "plateTungsten", "plateUranium", "plateZirconium"));
            ingotBmeMmeBlacklist.addAll(Arrays.asList("ingotAluminum", "ingotAluminium", "ingotAluminumbrass", "ingotAluminiumbrass", "ingotBeryllium", "ingotBoron", "ingotCadmium", "ingotChrome", "ingotChromium", "ingotGalvanizedsteel", "ingotIridium", "ingotMagnesium", "ingotManganese", "ingotNichrome", "ingotOsmium", "ingotPlutonium", "ingotRutile", "ingotStainlesssteel", "ingotTantalum", "ingotTitanium", "ingotThorium", "ingotTungsten", "ingotUranium", "ingotZirconium"));
        }
        String[] var2 = OreDictionary.getOreNames();
        int var3 = var2.length;
        if (Ic2cExtrasRecipes.enableAutoOredictRecipes) {
            for (int var4 = 0; var4 < var3; ++var4) {
                NonNullList listRods;
                NonNullList listGears;
                NonNullList listPlates;
                String plate;
                String id = var2[var4];
                if (!id.startsWith("ingot")) continue;
                if (!(ingotBlacklist.contains(id) || gemBlacklist.contains(id) || ingotBmeMmeBlacklist.contains(id) || !OreDictionary.doesOreNameExist((String)(plate = "plate" + id.substring(5))) || (listPlates = OreDictionary.getOres((String)plate, (boolean)false)).isEmpty())) {
                    TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict(id, 1), (ItemStack)listPlates.get(0));
                    if (Ic2cExtrasRecipes.enableHammerRecipes && !ingotGTBlacklist.contains(id)) {
                        if (Ic2cExtrasRecipes.enableTwoPlatesPerIngot) {
                            recipes.addRecipe((ItemStack)listPlates.get(0), new Object[]{"H", "I", "I", Character.valueOf('H'), "craftingToolForgeHammer", Character.valueOf('I'), id});
                        } else {
                            recipes.addRecipe((ItemStack)listPlates.get(0), new Object[]{"H", "I", Character.valueOf('H'), "craftingToolForgeHammer", Character.valueOf('I'), id});
                        }
                    }
                }
                if (gemBlacklist.contains(id)) continue;
                String gear = "gear" + id.substring(5);
                String rod = "rod" + id.substring(5);
                if (OreDictionary.doesOreNameExist((String)gear) && !(listGears = OreDictionary.getOres((String)gear, (boolean)false)).isEmpty()) {
                    TileEntityMetalBender.addRecipe((IRecipeInput)new RecipeInputOreDict(id, 4), new ItemStack((Item)Registry.gearingPress), (ItemStack)listGears.get(0));
                }
                if (!OreDictionary.doesOreNameExist((String)rod) || (listRods = OreDictionary.getOres((String)rod, (boolean)false)).isEmpty()) continue;
                TileEntityMetalBender.addRecipe((IRecipeInput)new RecipeInputOreDict(id, 1), new ItemStack((Item)Registry.lathingPress), StackUtil.copyWithSize((ItemStack)((ItemStack)listRods.get(0)), (int)2));
            }
        }
    }

    public static void initFluidFillingndEmptyingRecipes() {
        for (Item item : Item.field_150901_e) {
            NonNullList items = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, items);
            for (ItemStack stack : items) {
                IFluidHandlerItem fillingCapability;
                ItemStack empty;
                FluidStack fluid;
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack.func_77946_l());
                if (handler == null) continue;
                if (MachineRecipes.hasDrainProperty((IFluidHandler)handler) && (fluid = handler.drain(Integer.MAX_VALUE, true)) != null && (empty = handler.getContainer()) != null) {
                    TileEntityFluidCanningMachine.addEmptyingRecipe((IRecipeInput)new RecipeInputItemStack(stack), empty, fluid);
                }
                if (!MachineRecipes.hasFillProperty((IFluidHandler)handler) || (fillingCapability = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null) continue;
                for (Fluid fluid2 : FluidRegistry.getRegisteredFluids().values()) {
                    int testFill = fillingCapability.fill(new FluidStack(fluid2, Integer.MAX_VALUE), false);
                    if (testFill <= 0) continue;
                    IFluidHandlerItem copiedCap = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    int fill = copiedCap.fill(new FluidStack(fluid2, Integer.MAX_VALUE), true);
                    FluidStack filledFluid = new FluidStack(fluid2, fill);
                    ItemStack filled = copiedCap.getContainer();
                    TileEntityFluidCanningMachine.addFillingRecipe((IRecipeInput)new RecipeInputItemStack(stack), filledFluid, filled);
                }
            }
        }
    }

    private static boolean hasDrainProperty(IFluidHandler fluidHandler) {
        for (IFluidTankProperties properties : fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasFillProperty(IFluidHandler fluidHandler) {
        for (IFluidTankProperties properties : fluidHandler.getTankProperties()) {
            if (!properties.canFill()) continue;
            return true;
        }
        return false;
    }

    public static void initMachineRecipes() {
        int lowHeat = 400;
        int mediumHeat = 600;
        ItemStack stoneDust = new ItemStack((Item)Registry.stoneDust);
        TileEntityOreWashingPlant.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedIron", 1), 1000, new ItemStack((Item)Registry.ironPurifiedCrushedOre, 1), new ItemStack((Item)Registry.ironTinyDust, 2), stoneDust);
        TileEntityOreWashingPlant.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedGold", 1), 1000, new ItemStack((Item)Registry.goldPurifiedCrushedOre, 1), new ItemStack((Item)Registry.goldTinyDust, 2), stoneDust);
        TileEntityOreWashingPlant.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedCopper", 1), 1000, new ItemStack((Item)Registry.copperPurifiedCrushedOre, 1), new ItemStack((Item)Registry.copperTinyDust, 2), stoneDust);
        TileEntityOreWashingPlant.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedTin", 1), 1000, new ItemStack((Item)Registry.tinPurifiedCrushedOre, 1), new ItemStack((Item)Registry.tinTinyDust, 2), stoneDust);
        TileEntityOreWashingPlant.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedSilver", 1), 1000, new ItemStack((Item)Registry.silverPurifiedCrushedOre, 1), new ItemStack((Item)Registry.silverTinyDust, 2), stoneDust);
        TileEntityOreWashingPlant.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedLead", 1), 1000, new ItemStack((Item)Registry.leadPurifiedCrushedOre, 1), new ItemStack((Item)Registry.leadTinyDust, 3), stoneDust);
        TileEntityOreWashingPlant.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(Blocks.field_150351_n, 1)), 100, stoneDust);
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedIron", 1), lowHeat, Ic2Items.ironDust, new ItemStack((Item)Registry.goldTinyDust, 1));
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedGold", 1), lowHeat, Ic2Items.goldDust, new ItemStack((Item)Registry.silverTinyDust, 1));
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedCopper", 1), lowHeat, Ic2Items.copperDust, new ItemStack((Item)Registry.tinTinyDust, 1));
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedTin", 1), lowHeat, Ic2Items.tinDust, new ItemStack((Item)Registry.ironTinyDust, 1));
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedSilver", 1), lowHeat, Ic2Items.silverDust, new ItemStack((Item)Registry.leadTinyDust, 1));
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedLead", 1), lowHeat, new ItemStack((Item)Registry.leadDust, 1), new ItemStack((Item)Registry.copperTinyDust, 1));
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedIron", 1), mediumHeat, Ic2Items.ironDust, new ItemStack((Item)Registry.goldTinyDust, 1), stoneDust);
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedGold", 1), mediumHeat, Ic2Items.goldDust, new ItemStack((Item)Registry.silverTinyDust, 1), stoneDust);
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedCopper", 1), mediumHeat, Ic2Items.copperDust, new ItemStack((Item)Registry.tinTinyDust, 1), stoneDust);
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedTin", 1), mediumHeat, Ic2Items.tinDust, new ItemStack((Item)Registry.ironTinyDust, 1), stoneDust);
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedSilver", 1), mediumHeat, Ic2Items.silverDust, stoneDust);
        TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedLead", 1), mediumHeat, new ItemStack((Item)Registry.leadDust, 1), stoneDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedIron", 1), (ItemStack)Ic2Items.ironDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedGold", 1), (ItemStack)Ic2Items.goldDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedCopper", 1), (ItemStack)Ic2Items.copperDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedTin", 1), (ItemStack)Ic2Items.tinDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedSilver", 1), (ItemStack)Ic2Items.silverDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedLead", 1), (ItemStack)new ItemStack((Item)Registry.leadDust, 1));
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedIron", 1), (ItemStack)Ic2Items.ironDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedGold", 1), (ItemStack)Ic2Items.goldDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedCopper", 1), (ItemStack)Ic2Items.copperDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedTin", 1), (ItemStack)Ic2Items.tinDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedSilver", 1), (ItemStack)Ic2Items.silverDust);
        TileEntityMacerator.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedLead", 1), (ItemStack)new ItemStack((Item)Registry.leadDust, 1));
        TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinyIron", 9), (ItemStack)Ic2Items.ironDust);
        TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinyGold", 9), (ItemStack)Ic2Items.goldDust);
        TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinyCopper", 9), (ItemStack)Ic2Items.copperDust);
        TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinyTin", 9), (ItemStack)Ic2Items.tinDust);
        TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinySilver", 9), (ItemStack)Ic2Items.silverDust);
        TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinyLead", 9), (ItemStack)new ItemStack((Item)Registry.leadDust));
        TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinyObsidian", 9), (ItemStack)Ic2Items.obsidianDust);
        TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinyBronze", 9), (ItemStack)Ic2Items.bronzeDust);
        if (Ic2cExtrasRecipes.enableHarderUranium) {
            TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinyUranium235", 9), (ItemStack)new ItemStack((Item)Registry.uranium235));
            TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinyUranium238", 9), (ItemStack)new ItemStack((Item)Registry.uranium238));
            TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustTinyPlutonium", 9), (ItemStack)new ItemStack((Item)Registry.plutoniumDust));
            TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustSmallUranium235", 4), (ItemStack)new ItemStack((Item)Registry.uranium235));
            TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustSmallUranium238", 4), (ItemStack)new ItemStack((Item)Registry.uranium238));
            TileEntityCompressor.addRecipe((IRecipeInput)new RecipeInputOreDict("dustSmallPlutonium", 4), (ItemStack)new ItemStack((Item)Registry.plutoniumDust));
        }
        if (Ic2cExtrasRecipes.enableEmptyRods) {
            TileEntityExtruder.addRecipe((IRecipeInput)new RecipeInputOreDict("plateIron", 1), new ItemStack((Item)Registry.emptyFuelRod));
        }
        if (Ic2cExtrasRecipes.enableCasingsRequirePlates) {
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotCopper", 1), new ItemStack((Item)Registry.copperPlate, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotTin", 1), new ItemStack((Item)Registry.tinPlate, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotSilver", 1), new ItemStack((Item)Registry.silverPlate, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotLead", 1), new ItemStack((Item)Registry.leadPlate, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotIron", 1), new ItemStack((Item)Registry.ironPlate, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotGold", 1), new ItemStack((Item)Registry.goldPlate, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotRefinedIron", 1), new ItemStack((Item)Registry.refinedIronPlate, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotSteel", 1), new ItemStack((Item)Registry.steelPlate, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotBronze", 1), new ItemStack((Item)Registry.bronzePlate, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("plateCopper", 1), new ItemStack((Item)Registry.copperCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("plateTin", 1), new ItemStack((Item)Registry.tinCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("plateSilver", 1), new ItemStack((Item)Registry.silverCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("plateLead", 1), new ItemStack((Item)Registry.leadCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("plateIron", 1), new ItemStack((Item)Registry.ironCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("plateGold", 1), new ItemStack((Item)Registry.goldCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("plateRefinedIron", 1), new ItemStack((Item)Registry.refinedIronCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("plateSteel", 1), new ItemStack((Item)Registry.steelCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("plateBronze", 1), new ItemStack((Item)Registry.bronzeCasing, 2), 0.7f);
        } else {
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotCopper", 1), new ItemStack((Item)Registry.copperCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotTin", 1), new ItemStack((Item)Registry.tinCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotSilver", 1), new ItemStack((Item)Registry.silverCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotLead", 1), new ItemStack((Item)Registry.leadCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotIron", 1), new ItemStack((Item)Registry.ironCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotGold", 1), new ItemStack((Item)Registry.goldCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotRefinedIron", 1), new ItemStack((Item)Registry.refinedIronCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotSteel", 1), new ItemStack((Item)Registry.steelCasing, 2), 0.7f);
            TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotBronze", 1), new ItemStack((Item)Registry.bronzeCasing, 2), 0.7f);
        }
        TileEntityRoller.addRecipe((IRecipeInput)new RecipeInputOreDict(Ic2cExtrasRecipes.getRefinedIronCasing(), 1), StackUtil.copyWithSize((ItemStack)Ic2Items.miningPipe, (int)1), 0.7f);
        TileEntityExtruder.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotCopper", 1), StackUtil.copyWithSize((ItemStack)Ic2Items.copperCable, (int)3), 0.7f);
        TileEntityExtruder.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotTin", 1), StackUtil.copyWithSize((ItemStack)Ic2Items.tinCable, (int)4), 0.7f);
        TileEntityExtruder.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotBronze", 1), StackUtil.copyWithSize((ItemStack)Ic2Items.bronzeCable, (int)3), 0.7f);
        TileEntityExtruder.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotGold", 1), StackUtil.copyWithSize((ItemStack)Ic2Items.goldCable, (int)6), 0.7f);
        TileEntityExtruder.addRecipe((IRecipeInput)new RecipeInputOreDict("casingTin", 1), StackUtil.copyWithSize((ItemStack)Ic2Items.tinCan, (int)1), 0.7f);
        TileEntityExtruder.addRecipe((IRecipeInput)new RecipeInputOreDict(Ic2cExtrasRecipes.getRefinedIronCasing(), 2), StackUtil.copyWithSize((ItemStack)Ic2Items.ironFence, (int)3), 0.7f);
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("gemDiamond"), new ItemStack((Item)Registry.diamondDust), 0.5f, "Diamond Dust");
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(Ic2Items.energyCrystal), new ItemStack((Item)Registry.energiumDust, 6), "Energium Dust");
        TileEntityCompressor.addRecipe((ItemStack)new ItemStack((Item)Registry.energiumDust), (int)6, (ItemStack)Ic2Items.energyCrystal);
        ClassicRecipes.earthExtractor.registerValue(5.85f, new ItemStack[]{stoneDust});
        if (!IC2.config.getFlag("SteelRecipes")) {
            if (Ic2cExtrasRecipes.enableCertainRecipesRequireSteel) {
                TileEntityExtruder.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotSteel", 1), StackUtil.copyWithSize((ItemStack)Ic2Items.ironCable, (int)6), 0.7f);
            } else {
                TileEntityExtruder.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotRefinedIron", 1), StackUtil.copyWithSize((ItemStack)Ic2Items.ironCable, (int)6), 0.7f);
            }
        } else {
            TileEntityExtruder.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotSteel", 1), StackUtil.copyWithSize((ItemStack)Ic2Items.ironCable, (int)6), 0.7f);
        }
        if (Ic2cExtrasRecipes.enableDensePlatesTakePlates) {
            ClassicRecipes.compressor.removeRecipe((IRecipeInput)new RecipeInputOreDict("ingotCopper", 8));
            TileEntityCompressor.addRecipe((String)"plateCopper", (int)9, (ItemStack)Ic2Items.denseCopperPlate);
            TileEntityCompressor.addRecipe((String)"plateIron", (int)9, (ItemStack)new ItemStack((Item)Registry.denseIronPlate));
        } else {
            TileEntityCompressor.addRecipe((String)"ingotIron", (int)8, (ItemStack)new ItemStack((Item)Registry.denseIronPlate));
        }
    }

    public static void initFurnaceRecipes() {
        GameRegistry.addSmelting((Item)Registry.ironCrushedOre, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.7f);
        GameRegistry.addSmelting((Item)Registry.goldCrushedOre, (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        GameRegistry.addSmelting((Item)Registry.copperCrushedOre, (ItemStack)StackUtil.copyWithSize((ItemStack)Ic2Items.copperIngot, (int)1), (float)0.5f);
        GameRegistry.addSmelting((Item)Registry.tinCrushedOre, (ItemStack)StackUtil.copyWithSize((ItemStack)Ic2Items.tinIngot, (int)1), (float)0.5f);
        GameRegistry.addSmelting((Item)Registry.silverCrushedOre, (ItemStack)StackUtil.copyWithSize((ItemStack)Ic2Items.silverIngot, (int)1), (float)0.5f);
        GameRegistry.addSmelting((Item)Registry.leadCrushedOre, (ItemStack)new ItemStack((Item)Registry.leadIngot), (float)0.5f);
        GameRegistry.addSmelting((Item)Registry.ironPurifiedCrushedOre, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.7f);
        GameRegistry.addSmelting((Item)Registry.goldPurifiedCrushedOre, (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        GameRegistry.addSmelting((Item)Registry.copperPurifiedCrushedOre, (ItemStack)StackUtil.copyWithSize((ItemStack)Ic2Items.copperIngot, (int)1), (float)0.5f);
        GameRegistry.addSmelting((Item)Registry.tinPurifiedCrushedOre, (ItemStack)StackUtil.copyWithSize((ItemStack)Ic2Items.tinIngot, (int)1), (float)0.5f);
        GameRegistry.addSmelting((Item)Registry.silverPurifiedCrushedOre, (ItemStack)StackUtil.copyWithSize((ItemStack)Ic2Items.silverIngot, (int)1), (float)0.5f);
        GameRegistry.addSmelting((Item)Registry.leadPurifiedCrushedOre, (ItemStack)new ItemStack((Item)Registry.leadIngot), (float)0.5f);
        GameRegistry.addSmelting((Item)Registry.leadDust, (ItemStack)new ItemStack((Item)Registry.leadIngot), (float)0.5f);
        GameRegistry.addSmelting((Item)Registry.ironTinyDust, (ItemStack)new ItemStack(Items.field_191525_da), (float)0.5f);
        GameRegistry.addSmelting((Item)Registry.goldTinyDust, (ItemStack)new ItemStack(Items.field_151074_bl), (float)0.5f);
    }

    public static void initReplaceMaceratorRecipes() {
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("oreIron"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("oreIron"), new ItemStack((Item)Registry.ironCrushedOre, 2), 0.7f, "ironOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("oreGold"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("oreGold"), new ItemStack((Item)Registry.goldCrushedOre, 2), 1.0f, "goldOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("oreCopper"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("oreCopper"), new ItemStack((Item)Registry.copperCrushedOre, 2), 0.3f, "copperOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("oreTin"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("oreTin"), new ItemStack((Item)Registry.tinCrushedOre, 2), 0.4f, "tinOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("oreSilver"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("oreSilver"), new ItemStack((Item)Registry.silverCrushedOre, 2), 0.8f, "silverOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("oreLead"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("oreLead"), new ItemStack((Item)Registry.leadCrushedOre, 2), 0.8f, "leadOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("orePoorIron"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("orePoorIron", 3), new ItemStack((Item)Registry.ironCrushedOre, 2), 0.7f, "ironPoorOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("orePoorGold"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("orePoorGold", 3), new ItemStack((Item)Registry.goldCrushedOre, 2), 1.0f, "goldPoorOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("orePoorCopper"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("orePoorCopper", 3), new ItemStack((Item)Registry.copperCrushedOre, 2), 0.3f, "copperPoorOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("orePoorTin"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("orePoorTin", 3), new ItemStack((Item)Registry.tinCrushedOre, 2), 0.4f, "tinPoorOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("orePoorSilver"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("orePoorSilver", 3), new ItemStack((Item)Registry.silverCrushedOre, 2), 0.8f, "silverPoorOre");
        ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("orePoorLead"));
        ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("orePoorLead", 3), new ItemStack((Item)Registry.leadCrushedOre, 2), 0.8f, "leadPoorOre");
    }

    public static void initMetalBenderRecipes() {
        for (IMachineRecipeList.RecipeEntry recipe : Ic2cExtrasRecipes.rolling.getRecipeMap()) {
            TileEntityMetalBender.addRecipe(recipe.getInput(), new ItemStack((Item)Registry.rollingPress), recipe.getOutput());
        }
        for (IMachineRecipeList.RecipeEntry recipe : Ic2cExtrasRecipes.extruding.getRecipeMap()) {
            TileEntityMetalBender.addRecipe(recipe.getInput(), new ItemStack((Item)Registry.extrudingPress), recipe.getOutput());
        }
        for (IMachineRecipeList.RecipeEntry recipe : Ic2cExtrasRecipes.cutting.getRecipeMap()) {
            TileEntityMetalBender.addRecipe(recipe.getInput(), new ItemStack((Item)Registry.cuttingPress), recipe.getOutput());
        }
    }
}

