/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.IComponent;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.registry.Registries;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.IBlockRenderer;
import net.malisis.core.renderer.IItemRenderer;
import net.malisis.core.renderer.IRenderWorldLast;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.Utils;
import net.malisis.core.util.callback.CallbackResult;
import net.malisis.core.util.callback.ICallback;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
@AutoLoad
public class ClientRegistry {
    Map<Block, IBlockRenderer> blockRenderers = Maps.newHashMap();
    Map<Item, IItemRenderer> itemRenderers = Maps.newHashMap();
    List<IRenderWorldLast> renderWorldLastRenderers = Lists.newArrayList();
    Map<Class<? extends MalisisRenderer<?>>, MalisisRenderer<?>> registeredRenderers = Maps.newHashMap();
    List<BlockRendererOverride> blockRendererOverrides = Lists.newArrayList();
    List<ItemRendererOverride> itemRendererOverrides = Lists.newArrayList();

    ClientRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MalisisRegistry.onInit(e -> {
            Block.field_149771_c.forEach(this::registerRenderer);
            Item.field_150901_e.forEach(this::registerRenderer);
        });
        MalisisRegistry.onRenderBlock(this::renderBlock, ICallback.CallbackOption.of());
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        for (IRenderWorldLast renderer : this.renderWorldLastRenderers) {
            if (!renderer.shouldRender(event, (IBlockAccess)Utils.getClientWorld())) continue;
            renderer.renderWorldLastEvent(event, (IBlockAccess)Utils.getClientWorld());
        }
    }

    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        Registries.processTextureStitchEvent(event.getMap());
    }

    private void registerRenderer(Object object) {
        Pair<Class<? extends MalisisRenderer<?>>, Class<? extends MalisisRenderer<?>>> rendererClasses = this.getRendererClasses(object);
        if (rendererClasses == null) {
            return;
        }
        MalisisRenderer<?> renderer = null;
        try {
            renderer = this.getRenderer((Class)rendererClasses.getLeft());
        }
        catch (IllegalAccessException | InstantiationException e) {
            MalisisCore.log.error("[MalisisRegistry] Failed to load {} renderer for {}", (Object)((Class)rendererClasses.getLeft()).getSimpleName(), (Object)object.getClass().getSimpleName(), (Object)e);
            return;
        }
        if (object instanceof Block && renderer != null) {
            this.blockRenderers.put((Block)object, renderer);
            object = Item.func_150898_a((Block)((Block)object));
        }
        try {
            renderer = this.getRenderer((Class)rendererClasses.getRight());
        }
        catch (IllegalAccessException | InstantiationException e) {
            MalisisCore.log.error("[MalisisRegistry] Failed to load {} renderer for {}", (Object)((Class)rendererClasses.getLeft()).getSimpleName(), (Object)object.getClass().getSimpleName());
            return;
        }
        if (object != Items.field_190931_a && renderer != null) {
            this.itemRenderers.put((Item)object, renderer);
        }
    }

    private Pair<Class<? extends MalisisRenderer<?>>, Class<? extends MalisisRenderer<?>>> getRendererClasses(Object object) {
        Class<?> objClass = object.getClass();
        MalisisRendered annotation = objClass.getAnnotation(MalisisRendered.class);
        if (annotation == null) {
            return null;
        }
        if (annotation.value() != DefaultRenderer.Null.class) {
            return Pair.of(annotation.value(), annotation.value());
        }
        return Pair.of(annotation.block(), annotation.item());
    }

    private MalisisRenderer<?> getRenderer(Class<? extends MalisisRenderer<?>> clazz) throws InstantiationException, IllegalAccessException {
        if (clazz == DefaultRenderer.Block.class) {
            return DefaultRenderer.block;
        }
        if (clazz == DefaultRenderer.Block.class) {
            return DefaultRenderer.item;
        }
        if (clazz == DefaultRenderer.Null.class) {
            return DefaultRenderer.nullRender;
        }
        MalisisRenderer<?> renderer = this.registeredRenderers.get(clazz);
        if (renderer == null) {
            renderer = clazz.newInstance();
            this.registeredRenderers.put(clazz, renderer);
        }
        return renderer;
    }

    private CallbackResult<Boolean> renderBlock(BufferBuilder buffer, IBlockAccess world, BlockPos pos, IBlockState state) {
        IBlockRenderer renderer = this.getBlockRendererOverride(world, pos, state);
        if (renderer == null) {
            renderer = this.blockRenderers.get(state.func_177230_c());
        }
        if (renderer == null) {
            return CallbackResult.noResult();
        }
        return CallbackResult.builder().value(renderer.renderBlock(buffer, world, new BlockPos((Vec3i)pos), state)).withReturn(true).result();
    }

    private IBlockRenderer getBlockRendererOverride(IBlockAccess world, BlockPos pos, IBlockState state) {
        for (BlockRendererOverride overrides : this.blockRendererOverrides) {
            IBlockRenderer renderer = overrides.get(world, pos, state);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    boolean renderItem(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        IItemRenderer renderer = this.getItemRendererOverride(itemStack);
        if (renderer == null) {
            renderer = this.itemRenderers.get(itemStack.func_77973_b());
        }
        if (renderer == null) {
            return false;
        }
        renderer.renderItem(itemStack, MalisisRenderer.getPartialTick());
        return true;
    }

    private IItemRenderer getItemRendererOverride(ItemStack itemStack) {
        for (ItemRendererOverride overrides : this.itemRendererOverrides) {
            IItemRenderer renderer = overrides.get(itemStack);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    static TextureAtlasSprite getParticleIcon(IBlockState state) {
        Icon icon = null;
        IIconProvider provider = IComponent.getComponent(IIconProvider.class, state.func_177230_c());
        if (provider instanceof IBlockIconProvider) {
            icon = ((IBlockIconProvider)provider).getParticleIcon(state);
        } else if (provider != null) {
            icon = provider.getIcon();
        }
        return icon != null ? icon : Icon.missing;
    }

    public static IItemRenderer getItemRenderer(Item item) {
        return Registries.clientRegistry.itemRenderers.get(item);
    }

    public static interface ItemRendererOverride {
        public IItemRenderer get(ItemStack var1);
    }

    public static interface BlockRendererOverride {
        public IBlockRenderer get(IBlockAccess var1, BlockPos var2, IBlockState var3);
    }
}

