/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkblock;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import gnu.trove.procedure.TLongProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.IComponent;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.Utils;
import net.malisis.core.util.WeakNested;
import net.malisis.core.util.callback.CallbackResult;
import net.malisis.core.util.callback.ICallback;
import net.malisis.core.util.chunkblock.ChunkBlockMessage;
import net.malisis.core.util.chunkblock.IChunkBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;

@AutoLoad
public class ChunkBlockHandler {
    private static ChunkBlockHandler instance = new ChunkBlockHandler();
    private WeakNested.Set<Chunk, BlockPos> serverChunks = new WeakNested.Set(Sets::newHashSet);
    private WeakNested.Set<Chunk, BlockPos> clientChunks = new WeakNested.Set(Sets::newHashSet);

    public ChunkBlockHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MalisisRegistry.onPreSetBlock(this::handleChunkBlock, ICallback.CallbackOption.of(ICallback.Priority.LOWEST));
    }

    public WeakNested.Set<Chunk, BlockPos> chunks(Chunk chunk) {
        return chunk.func_177412_p().field_72995_K ? this.clientChunks : this.serverChunks;
    }

    private CallbackResult<Void> handleChunkBlock(Chunk chunk, BlockPos pos, IBlockState oldState, IBlockState newState) {
        IChunkBlock cb = IComponent.getComponent(IChunkBlock.class, oldState.func_177230_c());
        if (cb != null) {
            this.removeCoord(chunk.func_177412_p(), pos, cb.blockRange());
        }
        if ((cb = IComponent.getComponent(IChunkBlock.class, newState.func_177230_c())) != null) {
            this.addCoord(chunk.func_177412_p(), pos, cb.blockRange());
        }
        return CallbackResult.noResult();
    }

    private void addCoord(World world, BlockPos pos, int size) {
        ChunkBlockHandler.getAffectedChunks(world, pos.func_177958_n(), pos.func_177952_p(), size).forEach(c -> this.addCoord((Chunk)c, pos));
    }

    private void addCoord(Chunk chunk, BlockPos pos) {
        this.chunks(chunk).add((Object)chunk, (Object)pos);
    }

    private void removeCoord(World world, BlockPos pos, int size) {
        ChunkBlockHandler.getAffectedChunks(world, pos.func_177958_n(), pos.func_177952_p(), size).forEach(c -> this.removeCoord((Chunk)c, pos));
    }

    private void removeCoord(Chunk chunk, BlockPos pos) {
        this.chunks(chunk).remove((Object)chunk, (Object)pos);
    }

    @SubscribeEvent
    public void onDataLoad(ChunkDataEvent.Load event) {
        if (event.getData().func_74764_b("chunkNotifier")) {
            this.chunks(event.getChunk()).addAll(event.getChunk(), this.readLongArray(event.getData()));
        }
    }

    @SubscribeEvent
    public void onDataSave(ChunkDataEvent.Save event) {
        Object coords = this.chunks(event.getChunk()).get((Object)event.getChunk());
        if (!coords.isEmpty()) {
            this.writeLongArray(event.getData(), (Set<BlockPos>)coords);
        }
    }

    private Set<BlockPos> readLongArray(NBTTagCompound compound) {
        ByteBuf bytes = Unpooled.copiedBuffer((byte[])compound.func_74770_j("chunkNotifier"));
        HashSet set = Sets.newHashSet();
        for (int i = 0; i < bytes.capacity() / 8; ++i) {
            set.add(BlockPos.func_177969_a((long)bytes.readLong()));
        }
        return set;
    }

    private void writeLongArray(NBTTagCompound compound, Set<BlockPos> set) {
        ByteBuf bytes = Unpooled.buffer((int)(set.size() * 8));
        set.forEach(p -> bytes.writeLong(p.func_177986_g()));
        compound.func_74773_a("chunkNotifier", bytes.array());
    }

    @SubscribeEvent
    public void onChunkWatched(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.getPlayer().field_70170_p.func_72964_e(event.getChunk().field_77276_a, event.getChunk().field_77275_b);
        Object coords = this.chunks(chunk).get((Object)chunk);
        if (!coords.isEmpty()) {
            ChunkBlockMessage.sendCoords(chunk, (Set<BlockPos>)coords, event.getPlayer());
        }
    }

    public void setCoords(int chunkX, int chunkZ, Set<BlockPos> coords) {
        Chunk chunk = Utils.getClientWorld().func_72964_e(chunkX, chunkZ);
        this.chunks(chunk).addAll(chunk, coords);
    }

    public static List<Chunk> getAffectedChunks(World world, int x, int z, int distance) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)(x - distance), 0.0, (double)(z - distance), (double)(x + distance + 1), 1.0, (double)(z + distance + 1));
        return ChunkBlockHandler.getAffectedChunks(world, aabb);
    }

    public static List<Chunk> getAffectedChunks(World world, AxisAlignedBB ... aabbs) {
        if (ArrayUtils.isEmpty((Object[])aabbs)) {
            return ImmutableList.of();
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            for (int cx = (int)Math.floor(aabb.field_72340_a) >> 4; cx <= (int)Math.ceil(aabb.field_72336_d) >> 4; ++cx) {
                for (int cz = (int)Math.floor(aabb.field_72339_c) >> 4; cz <= (int)Math.ceil(aabb.field_72334_f) >> 4; ++cz) {
                    if (world.func_72863_F() == null || world.func_72863_F().func_186026_b(cx, cz) == null) continue;
                    chunks.add(world.func_72964_e(cx, cz));
                }
            }
        }
        return chunks;
    }

    public static ChunkBlockHandler get() {
        return instance;
    }

    public static abstract class ChunkProcedure
    implements TLongProcedure {
        protected World world;
        protected Chunk chunk;
        protected MBlockState state;

        protected void set(Chunk chunk) {
            this.world = chunk.func_177412_p();
            this.chunk = chunk;
        }

        protected boolean check(long coord) {
            this.state = new MBlockState((IBlockAccess)this.world, coord);
            if (!(this.state.getBlock() instanceof IChunkBlock)) {
                MalisisCore.log.info("[ChunkNotificationHandler]  Removing invalid {} coordinate : {} in chunk {},{}", (Object)(this.world.field_72995_K ? "client" : "server"), (Object)this.state, (Object)this.chunk.field_76635_g, (Object)this.chunk.field_76647_h);
                ChunkBlockHandler.get().removeCoord(this.chunk, this.state.getPos());
                return false;
            }
            return true;
        }

        protected void clean() {
            this.world = null;
            this.chunk = null;
            this.state = null;
        }
    }
}

