/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.appeng.grid;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumicenergistics.integration.appeng.grid.IThEGridHost;
import thaumicenergistics.part.PartBase;

public class ThEGridBlock
implements IGridBlock {
    private IThEGridHost host;
    private ItemStack rep;
    private TileEntity repTE;
    private boolean inWorld;
    private double idlePower = 1.0;

    public ThEGridBlock(IThEGridHost host, TileEntity rep, boolean inWorld) {
        this.host = host;
        this.repTE = rep;
        this.inWorld = inWorld;
    }

    public ThEGridBlock(IThEGridHost host, ItemStack rep, boolean inWorld) {
        this.host = host;
        this.rep = rep;
        this.inWorld = inWorld;
    }

    public ThEGridBlock(PartBase part) {
        this.host = part;
        this.rep = part.getItemStack(PartItemStack.NETWORK);
        this.inWorld = false;
        this.idlePower = part.getIdlePowerUsage();
    }

    public double getIdlePowerUsage() {
        return this.idlePower;
    }

    @Nonnull
    public EnumSet<GridFlags> getFlags() {
        return EnumSet.of(GridFlags.REQUIRE_CHANNEL);
    }

    public boolean isWorldAccessible() {
        return this.inWorld;
    }

    @Nonnull
    public DimensionalCoord getLocation() {
        return this.host.getLocation();
    }

    @Nonnull
    public AEColor getGridColor() {
        return AEColor.TRANSPARENT;
    }

    public void onGridNotification(@Nonnull GridNotification gridNotification) {
    }

    @Deprecated
    public void setNetworkStatus(IGrid grid, int usedChannels) {
    }

    @Nonnull
    public EnumSet<EnumFacing> getConnectableSides() {
        return EnumSet.allOf(EnumFacing.class);
    }

    @Nonnull
    public IGridHost getMachine() {
        return this.host;
    }

    public void gridChanged() {
        this.host.gridChanged();
    }

    @Nullable
    public ItemStack getMachineRepresentation() {
        if (this.repTE != null) {
            World world = this.repTE.func_145831_w();
            BlockPos pos = this.repTE.func_174877_v();
            IBlockState state = world.func_180495_p(pos);
            return new ItemStack(state.func_177230_c());
        }
        if (this.rep == null) {
            return ItemStack.field_190927_a;
        }
        return this.rep;
    }
}

