/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.part;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.appeng.ThEPartModel;
import thaumicenergistics.item.part.ItemEssentiaExportBus;
import thaumicenergistics.part.PartSharedEssentiaBus;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.ThELog;

public class PartEssentiaExportBus
extends PartSharedEssentiaBus {
    public static ResourceLocation[] MODELS = new ResourceLocation[]{new ResourceLocation("thaumicenergistics", "part/essentia_export_bus/base"), new ResourceLocation("thaumicenergistics", "part/essentia_export_bus/on"), new ResourceLocation("thaumicenergistics", "part/essentia_export_bus/off"), new ResourceLocation("thaumicenergistics", "part/essentia_export_bus/has_channel")};
    private static IPartModel MODEL_ON = new ThEPartModel(MODELS[0], MODELS[1]);
    private static IPartModel MODEL_OFF = new ThEPartModel(MODELS[0], MODELS[2]);
    private static IPartModel MODEL_HAS_CHANNEL = new ThEPartModel(MODELS[0], MODELS[3]);
    private boolean reportedWarning = false;

    public PartEssentiaExportBus(ItemEssentiaExportBus item) {
        super(item);
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(ThEApi.instance().config().tickTimeEssentiaExportBusMin(), ThEApi.instance().config().tickTimeEssentiaExportBusMax(), false, false);
    }

    @Override
    public boolean canWork() {
        return this.getConnectedTE() != null && this.config.hasAspects();
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.canWork()) {
            return TickRateModulation.IDLE;
        }
        if (this.getConnectedTE() instanceof IAspectContainer) {
            IAspectContainer container = (IAspectContainer)this.getConnectedTE();
            IStorageGrid storageGrid = (IStorageGrid)this.getGridNode().getGrid().getCache(IStorageGrid.class);
            IMEMonitor storage = storageGrid.getInventory((IStorageChannel)this.getChannel());
            for (Aspect aspect : this.config) {
                int notAdded;
                if (aspect == null || !container.doesContainerAccept(aspect) || !AEUtil.doesStorageContain((IMEInventory)storage, aspect)) continue;
                IAEEssentiaStack extracted = (IAEEssentiaStack)storage.extractItems((IAEStack)AEUtil.getAEStackFromAspect(aspect, this.calculateAmountToSend()), Actionable.SIMULATE, this.source);
                try {
                    notAdded = container.addToContainer(extracted.getAspect(), (int)extracted.getStackSize());
                }
                catch (NullPointerException ignored) {
                    if (!this.reportedWarning) {
                        ThELog.warn("container.addToContainer threw a NullPointerException. Thaumcraft Bug. Nividica/ThaumicEnergistics#361. Remove EssentiaExportBus from {}", this.hostTile != null ? this.hostTile.func_174877_v() : this.getConnectedTE().func_174877_v());
                    }
                    this.reportedWarning = true;
                    return TickRateModulation.IDLE;
                }
                this.reportedWarning = false;
                extracted.decStackSize(notAdded);
                storage.extractItems((IAEStack)extracted, Actionable.MODULATE, this.source);
                return TickRateModulation.FASTER;
            }
            return TickRateModulation.SLOWER;
        }
        return TickRateModulation.IDLE;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return MODEL_HAS_CHANNEL;
            }
            return MODEL_ON;
        }
        return MODEL_OFF;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d vec3d) {
        if (ForgeUtil.isClient() || player.func_70093_af() && AEUtil.isWrench(player.func_184586_b(hand), player, this.getTile().func_174877_v())) {
            return false;
        }
        GuiHandler.openGUI(ModGUIs.ESSENTIA_EXPORT_BUS, player, this.hostTile.func_174877_v(), this.side);
        return true;
    }
}

