/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.implementations.guiobjects.INetworkTool;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class ContainerNetworkStatus
extends AEBaseContainer {
    @GuiSync(value=0)
    public long avgAddition;
    @GuiSync(value=1)
    public long powerUsage;
    @GuiSync(value=2)
    public long currentPower;
    @GuiSync(value=3)
    public long maxPower;
    private IGrid network;
    private int delay = 40;

    public ContainerNetworkStatus(InventoryPlayer ip, INetworkTool te) {
        super(ip, null, null);
        IGridHost host = te.getGridHost();
        if (host != null) {
            this.findNode(host, AEPartLocation.INTERNAL);
            for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                this.findNode(host, d);
            }
        }
        if (this.network == null && Platform.isServer()) {
            this.setValidContainer(false);
        }
    }

    private void findNode(IGridHost host, AEPartLocation d) {
        IGridNode node;
        if (this.network == null && (node = host.getGridNode(d)) != null) {
            this.network = node.getGrid();
        }
    }

    @Override
    public void func_75142_b() {
        ++this.delay;
        if (Platform.isServer() && this.delay > 15 && this.network != null) {
            this.delay = 0;
            IEnergyGrid eg = (IEnergyGrid)this.network.getCache(IEnergyGrid.class);
            if (eg != null) {
                this.setAverageAddition((long)(100.0 * eg.getAvgPowerInjection()));
                this.setPowerUsage((long)(100.0 * eg.getAvgPowerUsage()));
                this.setCurrentPower((long)(100.0 * eg.getStoredPower()));
                this.setMaxPower((long)(100.0 * eg.getMaxStoredPower()));
            }
            try {
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                for (Class clazz : this.network.getMachinesClasses()) {
                    IItemList<AEItemStack> list = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
                    for (IGridNode iGridNode : this.network.getMachines(clazz)) {
                        IGridBlock blk = iGridNode.getGridBlock();
                        ItemStack is = blk.getMachineRepresentation();
                        if (is.func_190926_b()) continue;
                        AEItemStack ais = AEItemStack.fromItemStack(is);
                        ais.setStackSize(1L);
                        ais.setCountRequestable((long)(blk.getIdlePowerUsage() * 100.0));
                        list.add(ais);
                    }
                    for (IAEItemStack iAEItemStack : list) {
                        piu.appendItem(iAEItemStack);
                    }
                }
                for (Object object : this.field_75149_d) {
                    if (!(object instanceof EntityPlayer)) continue;
                    NetworkHandler.instance().sendTo(piu, (EntityPlayerMP)object);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.func_75142_b();
    }

    public long getCurrentPower() {
        return this.currentPower;
    }

    private void setCurrentPower(long currentPower) {
        this.currentPower = currentPower;
    }

    public long getMaxPower() {
        return this.maxPower;
    }

    private void setMaxPower(long maxPower) {
        this.maxPower = maxPower;
    }

    public long getAverageAddition() {
        return this.avgAddition;
    }

    private void setAverageAddition(long avgAddition) {
        this.avgAddition = avgAddition;
    }

    public long getPowerUsage() {
        return this.powerUsage;
    }

    private void setPowerUsage(long powerUsage) {
        this.powerUsage = powerUsage;
    }
}

