/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.compass;

import appeng.core.worlddata.MeteorDataNameEncoder;
import appeng.services.compass.CompassException;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.Nonnull;

public final class CompassRegion {
    private final int lowX;
    private final int lowZ;
    private final int world;
    private final File worldCompassFolder;
    private final MeteorDataNameEncoder encoder;
    private boolean hasFile = false;
    private RandomAccessFile raf = null;
    private ByteBuffer buffer;

    public CompassRegion(int cx, int cz, int worldID, @Nonnull File worldCompassFolder) {
        Preconditions.checkNotNull((Object)worldCompassFolder);
        Preconditions.checkArgument((boolean)worldCompassFolder.isDirectory());
        this.world = worldID;
        this.worldCompassFolder = worldCompassFolder;
        this.encoder = new MeteorDataNameEncoder(0);
        int region_x = cx >> 10;
        int region_z = cz >> 10;
        this.lowX = region_x << 10;
        this.lowZ = region_z << 10;
        this.openFile(false);
    }

    void close() {
        try {
            if (this.hasFile) {
                this.buffer = null;
                this.raf.close();
                this.raf = null;
                this.hasFile = false;
            }
        }
        catch (Throwable t) {
            throw new CompassException(t);
        }
    }

    boolean hasBeacon(int cx, int cz) {
        int val;
        return this.hasFile && (val = this.read(cx &= 0x3FF, cz &= 0x3FF)) != 0;
    }

    void setHasBeacon(int cx, int cz, int cdy, boolean hasBeacon) {
        cx &= 0x3FF;
        cz &= 0x3FF;
        this.openFile(hasBeacon);
        if (this.hasFile) {
            int val;
            int originalVal = val = this.read(cx, cz);
            val = hasBeacon ? (val |= 1 << cdy) : (val &= ~(1 << cdy));
            if (originalVal != val) {
                this.write(cx, cz, val);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void openFile(boolean create) {
        if (this.hasFile) {
            return;
        }
        File file = this.getFile();
        if (create || this.isFileExistent(file)) {
            try {
                this.raf = new RandomAccessFile(file, "rw");
                FileChannel fc = this.raf.getChannel();
                this.buffer = fc.map(FileChannel.MapMode.READ_WRITE, 0L, 0x100000L);
                this.hasFile = true;
            }
            catch (Throwable t) {
                throw new CompassException(t);
            }
        }
    }

    private File getFile() {
        String fileName = this.encoder.encode(this.world, this.lowX, this.lowZ);
        return new File(this.worldCompassFolder, fileName);
    }

    private boolean isFileExistent(File file) {
        return file.exists() && file.isFile();
    }

    private int read(int cx, int cz) {
        try {
            return this.buffer.get(cx + cz * 1024);
        }
        catch (IndexOutOfBoundsException outOfBounds) {
            return 0;
        }
        catch (Throwable t) {
            throw new CompassException(t);
        }
    }

    private void write(int cx, int cz, int val) {
        try {
            this.buffer.put(cx + cz * 1024, (byte)val);
        }
        catch (Throwable t) {
            throw new CompassException(t);
        }
    }
}

