/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.AEApi;
import appeng.api.movable.IMovableHandler;
import appeng.api.movable.IMovableRegistry;
import appeng.api.util.AEPartLocation;
import appeng.api.util.WorldCoord;
import appeng.core.AELog;
import appeng.core.worlddata.WorldData;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class CachedPlane {
    private final int x_size;
    private final int z_size;
    private final int cx_size;
    private final int cz_size;
    private final int x_offset;
    private final int y_offset;
    private final int z_offset;
    private final int y_size;
    private final Chunk[][] myChunks;
    private final Column[][] myColumns;
    private final List<TileEntity> tiles = new ArrayList<TileEntity>();
    private final List<NextTickListEntry> ticks = new ArrayList<NextTickListEntry>();
    private final World world;
    private final IMovableRegistry reg = AEApi.instance().registries().movable();
    private final List<WorldCoord> updates = new ArrayList<WorldCoord>();
    private int verticalBits;
    private final IBlockState matrixBlockState;

    public CachedPlane(World w, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Block matrixFrameBlock = AEApi.instance().definitions().blocks().matrixFrame().maybeBlock().orElse(null);
        this.matrixBlockState = matrixFrameBlock != null ? matrixFrameBlock.func_176223_P() : null;
        this.world = w;
        this.x_size = maxX - minX + 1;
        this.y_size = maxY - minY + 1;
        this.z_size = maxZ - minZ + 1;
        this.x_offset = minX;
        this.y_offset = minY;
        this.z_offset = minZ;
        int minCX = minX >> 4;
        int minCY = minY >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCY = maxY >> 4;
        int maxCZ = maxZ >> 4;
        this.cx_size = maxCX - minCX + 1;
        int cy_size = maxCY - minCY + 1;
        this.cz_size = maxCZ - minCZ + 1;
        this.myChunks = new Chunk[this.cx_size][this.cz_size];
        this.myColumns = new Column[this.x_size][this.z_size];
        this.verticalBits = 0;
        for (int cy = 0; cy < cy_size; ++cy) {
            this.verticalBits |= 1 << minCY + cy;
        }
        for (int x = 0; x < this.x_size; ++x) {
            for (int z = 0; z < this.z_size; ++z) {
                this.myColumns[x][z] = new Column(w.func_72964_e(minX + x >> 4, minZ + z >> 4), minX + x & 0xF, minZ + z & 0xF, minCY, cy_size);
            }
        }
        IMovableRegistry mr = AEApi.instance().registries().movable();
        for (int cx = 0; cx < this.cx_size; ++cx) {
            for (int cz = 0; cz < this.cz_size; ++cz) {
                Chunk c;
                ArrayList rawTiles = new ArrayList();
                ArrayList<BlockPos> deadTiles = new ArrayList<BlockPos>();
                this.myChunks[cx][cz] = c = w.func_72964_e(minCX + cx, minCZ + cz);
                rawTiles.addAll(((HashMap)c.func_177434_r()).entrySet());
                for (Map.Entry entry : rawTiles) {
                    BlockPos cp = (BlockPos)entry.getKey();
                    TileEntity te = (TileEntity)entry.getValue();
                    BlockPos tePOS = te.func_174877_v();
                    if (tePOS.func_177958_n() < minX || tePOS.func_177958_n() > maxX || tePOS.func_177956_o() < minY || tePOS.func_177956_o() > maxY || tePOS.func_177952_p() < minZ || tePOS.func_177952_p() > maxZ) continue;
                    if (mr.askToMove(te)) {
                        this.tiles.add(te);
                        deadTiles.add(cp);
                        continue;
                    }
                    BlockStorageData details = new BlockStorageData();
                    this.myColumns[tePOS.func_177958_n() - minX][tePOS.func_177952_p() - minZ].fillData(tePOS.func_177956_o(), details);
                    if (details.state != null && details.state.func_177230_c() == Platform.AIR_BLOCK && details.state.func_185904_a().func_76222_j()) {
                        w.func_175698_g(tePOS);
                        continue;
                    }
                    this.myColumns[tePOS.func_177958_n() - minX][tePOS.func_177952_p() - minZ].setSkip(tePOS.func_177956_o());
                }
                for (BlockPos blockPos : deadTiles) {
                    c.func_177434_r().remove(blockPos);
                }
                long k = this.getWorld().func_82737_E();
                List list = this.getWorld().func_72920_a(c, false);
                if (list == null) continue;
                for (NextTickListEntry entry : list) {
                    BlockPos tePOS = entry.field_180282_a;
                    if (tePOS.func_177958_n() < minX || tePOS.func_177958_n() > maxX || tePOS.func_177956_o() < minY || tePOS.func_177956_o() > maxY || tePOS.func_177952_p() < minZ || tePOS.func_177952_p() > maxZ) continue;
                    NextTickListEntry newEntry = new NextTickListEntry(tePOS, entry.func_151351_a());
                    newEntry.field_77180_e = entry.field_77180_e - k;
                    this.ticks.add(newEntry);
                }
            }
        }
        for (TileEntity te : this.tiles) {
            try {
                this.getWorld().field_147482_g.remove(te);
                if (!(te instanceof ITickable)) continue;
                this.getWorld().field_175730_i.remove(te);
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    private IMovableHandler getHandler(TileEntity te) {
        IMovableRegistry mr = AEApi.instance().registries().movable();
        return mr.getHandler(te);
    }

    void swap(CachedPlane dst) {
        IMovableRegistry mr = AEApi.instance().registries().movable();
        if (dst.x_size == this.x_size && dst.y_size == this.y_size && dst.z_size == this.z_size) {
            AELog.info("Block Copy Scale: " + this.x_size + ", " + this.y_size + ", " + this.z_size, new Object[0]);
            long startTime = System.nanoTime();
            BlockStorageData aD = new BlockStorageData();
            BlockStorageData bD = new BlockStorageData();
            for (int x = 0; x < this.x_size; ++x) {
                for (int z = 0; z < this.z_size; ++z) {
                    Column a = this.myColumns[x][z];
                    Column b = dst.myColumns[x][z];
                    for (int y = 0; y < this.y_size; ++y) {
                        int src_y = y + this.y_offset;
                        int dst_y = y + dst.y_offset;
                        if (a.doNotSkip(src_y) && b.doNotSkip(dst_y)) {
                            a.fillData(src_y, aD);
                            b.fillData(dst_y, bD);
                            a.setBlockIDWithMetadata(src_y, bD);
                            b.setBlockIDWithMetadata(dst_y, aD);
                            continue;
                        }
                        this.markForUpdate(x + this.x_offset, src_y, z + this.z_offset);
                        dst.markForUpdate(x + dst.x_offset, dst_y, z + dst.z_offset);
                    }
                }
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            AELog.info("Block Copy Time: " + duration, new Object[0]);
            for (TileEntity te : this.tiles) {
                BlockPos tePOS = te.func_174877_v();
                dst.addTile(tePOS.func_177958_n() - this.x_offset, tePOS.func_177956_o() - this.y_offset, tePOS.func_177952_p() - this.z_offset, te, this, mr);
            }
            for (TileEntity te : dst.tiles) {
                BlockPos tePOS = te.func_174877_v();
                this.addTile(tePOS.func_177958_n() - dst.x_offset, tePOS.func_177956_o() - dst.y_offset, tePOS.func_177952_p() - dst.z_offset, te, dst, mr);
            }
            for (NextTickListEntry entry : this.ticks) {
                BlockPos tePOS = entry.field_180282_a;
                dst.addTick(tePOS.func_177958_n() - this.x_offset, tePOS.func_177956_o() - this.y_offset, tePOS.func_177952_p() - this.z_offset, entry);
            }
            for (NextTickListEntry entry : dst.ticks) {
                BlockPos tePOS = entry.field_180282_a;
                this.addTick(tePOS.func_177958_n() - dst.x_offset, tePOS.func_177956_o() - dst.y_offset, tePOS.func_177952_p() - dst.z_offset, entry);
            }
            startTime = System.nanoTime();
            this.updateChunks();
            dst.updateChunks();
            endTime = System.nanoTime();
            duration = endTime - startTime;
            AELog.info("Update Time: " + duration, new Object[0]);
        }
    }

    private void markForUpdate(int x, int y, int z) {
        this.updates.add(new WorldCoord(x, y, z));
        for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
            this.updates.add(new WorldCoord(x + d.xOffset, y + d.yOffset, z + d.zOffset));
        }
    }

    private void addTick(int x, int y, int z, NextTickListEntry entry) {
        this.world.func_175684_a(new BlockPos(x + this.x_offset, y + this.y_offset, z + this.z_offset), entry.func_151351_a(), (int)entry.field_77180_e);
    }

    private void addTile(int x, int y, int z, TileEntity te, CachedPlane alternateDestination, IMovableRegistry mr) {
        block6: {
            try {
                Column c = this.myColumns[x][z];
                if (c.doNotSkip(y + this.y_offset) || alternateDestination == null) {
                    block5: {
                        IMovableHandler handler = this.getHandler(te);
                        try {
                            handler.moveTile(te, this.world, new BlockPos(x + this.x_offset, y + this.y_offset, z + this.z_offset));
                        }
                        catch (Throwable e) {
                            AELog.debug(e);
                            BlockPos pos = new BlockPos(x, y, z);
                            te.func_145834_a(this.world);
                            te.func_174878_a(pos);
                            c.c.func_177426_a(new BlockPos(c.x, y + y, c.z), te);
                            if (!c.c.func_177410_o()) break block5;
                            this.world.func_175700_a(te);
                            this.world.func_184138_a(pos, this.world.func_180495_p(pos), this.world.func_180495_p(pos), z);
                        }
                    }
                    mr.doneMoving(te);
                    break block6;
                }
                alternateDestination.addTile(x, y, z, te, null, mr);
            }
            catch (Throwable e) {
                AELog.debug(e);
            }
        }
    }

    private void updateChunks() {
        Chunk c;
        int z;
        int x;
        for (x = 0; x < this.cx_size; ++x) {
            for (z = 0; z < this.cz_size; ++z) {
                c = this.myChunks[x][z];
                c.func_76613_n();
                c.func_76603_b();
                c.func_177427_f(true);
            }
        }
        for (x = 0; x < this.cx_size; ++x) {
            for (z = 0; z < this.cz_size; ++z) {
                c = this.myChunks[x][z];
                for (int y = 1; y < 255; y += 32) {
                    WorldData.instance().compassData().service().updateArea(this.getWorld(), c.field_76635_g << 4, y, c.field_76647_h << 4);
                }
                Platform.sendChunk(c, this.verticalBits);
            }
        }
    }

    List<WorldCoord> getUpdates() {
        return this.updates;
    }

    World getWorld() {
        return this.world;
    }

    private class Column {
        private final int x;
        private final int z;
        private final Chunk c;
        private List<Integer> skipThese = null;

        public Column(Chunk chunk, int x, int z, int chunkY, int chunkHeight) {
            this.x = x;
            this.z = z;
            this.c = chunk;
            ExtendedBlockStorage[] storage = this.c.func_76587_i();
            for (int ay = 0; ay < chunkHeight; ++ay) {
                int by = ay + chunkY;
                ExtendedBlockStorage extendedblockstorage = storage[by];
                if (extendedblockstorage != null) continue;
                extendedblockstorage = storage[by] = new ExtendedBlockStorage(by << 4, this.c.func_177412_p().field_73011_w.func_191066_m());
            }
        }

        private void setBlockIDWithMetadata(int y, BlockStorageData data) {
            if (data.state == CachedPlane.this.matrixBlockState) {
                data.state = Platform.AIR_BLOCK.func_176223_P();
            }
            ExtendedBlockStorage[] storage = this.c.func_76587_i();
            ExtendedBlockStorage extendedBlockStorage = storage[y >> 4];
            extendedBlockStorage.func_177484_a(this.x, y & 0xF, this.z, data.state);
            extendedBlockStorage.func_76677_d(this.x, y & 0xF, this.z, data.light);
        }

        private void fillData(int y, BlockStorageData data) {
            ExtendedBlockStorage[] storage = this.c.func_76587_i();
            ExtendedBlockStorage extendedblockstorage = storage[y >> 4];
            data.state = extendedblockstorage.func_177485_a(this.x, y & 0xF, this.z);
            data.light = extendedblockstorage.func_76674_d(this.x, y & 0xF, this.z);
        }

        private boolean doNotSkip(int y) {
            ExtendedBlockStorage[] storage = this.c.func_76587_i();
            ExtendedBlockStorage extendedblockstorage = storage[y >> 4];
            if (CachedPlane.this.reg.isBlacklisted(extendedblockstorage.func_177485_a(this.x, y & 0xF, this.z).func_177230_c())) {
                return false;
            }
            return this.skipThese == null || !this.skipThese.contains(y);
        }

        private void setSkip(int yCoord) {
            if (this.skipThese == null) {
                this.skipThese = new ArrayList<Integer>();
            }
            this.skipThese.add(yCoord);
        }
    }

    private static class BlockStorageData {
        public IBlockState state;
        public int light;

        private BlockStorageData() {
        }
    }
}

