/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheMiscBlocks;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityLavaFactoryController
extends TileEntityBase
implements IEnergyDisplay {
    public static final int NOT_MULTI = 0;
    public static final int HAS_LAVA = 1;
    public static final int HAS_AIR = 2;
    public static final int ENERGY_USE = 150000;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(300000, 2000, 0);
    private int currentWorkTime;
    private int oldEnergy;

    public TileEntityLavaFactoryController() {
        super("lavaFactory");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("WorkTime", this.currentWorkTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentWorkTime = compound.func_74762_e("WorkTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (this.storage.getEnergyStored() >= 150000 && this.isMultiblock() == 2) {
                ++this.currentWorkTime;
                if (this.currentWorkTime >= 200) {
                    this.currentWorkTime = 0;
                    this.field_145850_b.func_180501_a(this.field_174879_c.func_177984_a(), Blocks.field_150353_l.func_176223_P(), 2);
                    this.storage.extractEnergyInternal(150000, false);
                }
            } else {
                this.currentWorkTime = 0;
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    public int isMultiblock() {
        BlockPos thisPos = this.field_174879_c;
        BlockPos[] positions = new BlockPos[]{thisPos.func_177982_a(1, 1, 0), thisPos.func_177982_a(-1, 1, 0), thisPos.func_177982_a(0, 1, 1), thisPos.func_177982_a(0, 1, -1)};
        if (WorldUtil.hasBlocksInPlacesGiven(positions, InitBlocks.blockMisc, TheMiscBlocks.LAVA_FACTORY_CASE.ordinal(), this.field_145850_b)) {
            BlockPos pos = thisPos.func_177984_a();
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                return 1;
            }
            if (block == null || this.field_145850_b.func_175623_d(pos)) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

