/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class InstancePool<T> {
    @Nullable
    private volatile WeakReference<Queue<T>> queue;

    @Nonnull
    public T take() {
        T t = this.getQueue().poll();
        return t == null ? this.create() : t;
    }

    public void recycle(T t) {
        this.clear(t);
        this.getQueue().offer(t);
    }

    protected void clear(T t) {
    }

    @Nonnull
    private Queue<T> getQueue() {
        ConcurrentLinkedQueue queue;
        WeakReference<Queue<T>> currentQueueRef = this.queue;
        if (currentQueueRef != null && (queue = (ConcurrentLinkedQueue)currentQueueRef.get()) != null) {
            return queue;
        }
        queue = new ConcurrentLinkedQueue();
        this.queue = new WeakReference(queue);
        return queue;
    }

    @Nonnull
    protected abstract T create();
}

