/*
 * Decompiled with CFR 0.152.
 */
package me.dierke9.discordcraft;

import club.minnced.discord.rpc.DiscordEventHandlers;
import club.minnced.discord.rpc.DiscordRPC;
import me.dierke9.discordcraft.events.MainEventHandler;
import me.dierke9.discordcraft.util.Presence;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="discordcraft", version="1.0", name="Discordcraft", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class MinecraftRichPresence {
    public static final String MODID = "discordcraft";
    public static final String VERSION = "1.0";
    public static final String NAME = "Discordcraft";
    public static Presence presence;
    private MainEventHandler eventHandler;
    public static boolean modEnabled;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        if (Config.discordApplicationID == null || Config.discordApplicationID.isEmpty() || Config.largeImageKey == null || Config.largeImageKey.isEmpty()) {
            logger.warn("Config incorrect using default values");
            Config.discordApplicationID = "529029853471834113";
            Config.largeImageKey = "defaultimage";
        }
        logger.info("Preinit of minecraft Rich Presence");
        presence = new Presence();
        DiscordRPC lib = null;
        try {
            lib = DiscordRPC.INSTANCE;
            modEnabled = true;
        }
        catch (Throwable e) {
            logger.error("Error in initialization of Discord Rich Prsence", e);
            modEnabled = false;
        }
        DiscordEventHandlers handlers = new DiscordEventHandlers();
        handlers.ready = user -> System.out.println("Ready!");
        lib.Discord_Initialize(Config.discordApplicationID, handlers, true, "");
        presence.setState("Starting up");
        presence.updatePresence();
        Runtime.getRuntime().addShutdownHook(new Thread(lib::Discord_Shutdown));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("Initializing Minecraft Rich Presence");
        this.eventHandler = new MainEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
        this.eventHandler.createDimManager();
    }

    @Mod.EventHandler
    public void onLoad(FMLLoadCompleteEvent e) {
        presence.setState("Main menu");
        presence.updatePresence();
    }

    static {
        modEnabled = false;
    }

    @net.minecraftforge.common.config.Config(modid="discordcraft")
    public static class Config {
        @Config.RequiresMcRestart
        @Config.Comment(value={"The applicationId of the Discord Rich presence"})
        public static String discordApplicationID = "529029853471834113";
        @Config.RequiresMcRestart
        @Config.Comment(value={"Big image used in the Rich Presence"})
        public static String largeImageKey = "defaultimage";
        @Config.RequiresMcRestart
        @Config.Comment(value={"Small circular image that will be used in the rich presence (optional)"})
        public static String smallImageKey = "minecrafticon";
        @Config.RequiresMcRestart
        @Config.Comment(value={"The name that should be displayed when hovering over the large image"})
        public static String modPackName = "";
        @Config.Comment(value={"Set to true if you want to display the ip of the server you are currently connected to"})
        public static boolean showIp = true;
    }
}

