/*
 * Decompiled with CFR 0.152.
 */
package me.dierke9.discordcraft.events;

import mcjty.rftoolsdim.api.dimension.IDimensionInformation;
import me.dierke9.discordcraft.MinecraftRichPresence;
import me.dierke9.discordcraft.util.RFToolsDimensionManager;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import net.minecraft.client.Minecraft;
import net.minecraft.world.DimensionType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="discordcraft", value={Side.CLIENT})
public class MainEventHandler {
    private RFToolsDimensionManager rfToolsDimensionManager;
    private Satellite satellite;

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent e) {
        if (e.getEntity().equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            CelestialBody body;
            MinecraftRichPresence.presence.setGCDim(false);
            MinecraftRichPresence.presence.setRFToolsDim(false);
            DimensionType dimType = e.getWorld().field_73011_w.func_186058_p();
            if (Loader.isModLoaded((String)"rftoolsdim") && this.rfToolsDimensionManager.isRFToolsDimension(e.getWorld(), dimType.func_186068_a())) {
                IDimensionInformation dimInfo = this.rfToolsDimensionManager.getDimensionInformation(e.getWorld(), dimType.func_186068_a());
                MinecraftRichPresence.presence.setRFToolsDim(true);
                MinecraftRichPresence.presence.setRFToolsDim(dimInfo.getName());
            }
            if (Loader.isModLoaded((String)"galacticraftcore") && (body = GalaxyRegistry.getCelestialBodyFromDimensionID((int)dimType.func_186068_a())) != null) {
                switch (body.getClass().getSimpleName().toLowerCase()) {
                    case "planet": {
                        if (dimType.func_186068_a() == 0) break;
                        MinecraftRichPresence.presence.setState("On planet " + body.getLocalizedName());
                        MinecraftRichPresence.presence.setGCDim(true);
                        break;
                    }
                    case "moon": {
                        Moon moon = (Moon)body;
                        if (moon.getUnlocalizedName().equalsIgnoreCase("moon.moon")) {
                            MinecraftRichPresence.presence.setState("On the Moon");
                        } else {
                            MinecraftRichPresence.presence.setState("On moon " + body.getLocalizedName() + " around " + moon.getParentPlanet().getLocalizedName());
                        }
                        MinecraftRichPresence.presence.setRFToolsDim(true);
                        break;
                    }
                    case "satellite": {
                        Satellite satellite = (Satellite)body;
                        String parent = satellite.getParentPlanet().getUnlocalizedName().equalsIgnoreCase("planet.overworld") ? "Earth" : satellite.getParentPlanet().getLocalizedName();
                        MinecraftRichPresence.presence.setState("Orbiting around " + parent + " on a space station");
                        MinecraftRichPresence.presence.setGCDim(true);
                    }
                }
            }
            if (!MinecraftRichPresence.presence.isGCDim() && !MinecraftRichPresence.presence.isRFToolsDim()) {
                MinecraftRichPresence.presence.setDimensionName(dimType.func_186065_b());
            }
            MinecraftRichPresence.presence.updatePresence();
        }
    }

    @SubscribeEvent
    public void onConnect(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        String details;
        String string = details = e.isLocal() ? "Singleplayer" : "Multiplayer ";
        if (!e.isLocal() && MinecraftRichPresence.Config.showIp) {
            details = details + Minecraft.func_71410_x().func_147104_D().field_78845_b;
        }
        MinecraftRichPresence.presence.setDetails(details);
        MinecraftRichPresence.presence.setState("Connecting...");
        MinecraftRichPresence.presence.updatePresence();
    }

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        MinecraftRichPresence.logger.info("Server Disconnect");
        MinecraftRichPresence.presence.setDetails("");
        MinecraftRichPresence.presence.setState("In Main menu");
        MinecraftRichPresence.presence.updatePresence();
    }

    public void createDimManager() {
        if (Loader.isModLoaded((String)"rftoolsdim")) {
            this.rfToolsDimensionManager = new RFToolsDimensionManager();
        }
    }
}

