/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.ArrayList;
import java.util.List;
import nc.integration.crafttweaker.CTHelper;
import nc.recipe.IngredientSorption;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.RecipeHelper;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IIngredient;
import nc.recipe.ingredient.IItemIngredient;
import net.minecraft.item.ItemStack;

public class RemoveProcessorRecipe
implements IAction {
    public static boolean hasErrored = false;
    public List<IItemIngredient> itemIngredients;
    public List<IFluidIngredient> fluidIngredients;
    public IngredientSorption type;
    public ProcessorRecipe recipe;
    public boolean wasNull;
    public boolean wrongSize;
    public final ProcessorRecipeHandler recipeHandler;

    public RemoveProcessorRecipe(ProcessorRecipeHandler recipeHandler, IngredientSorption type, List<crafttweaker.api.item.IIngredient> ctIngredients) {
        IIngredient<ItemStack> ingredient;
        int i;
        int fluidSize;
        this.recipeHandler = recipeHandler;
        this.type = type;
        int itemSize = type == IngredientSorption.INPUT ? recipeHandler.itemInputSize : recipeHandler.itemOutputSize;
        int n = fluidSize = type == IngredientSorption.INPUT ? recipeHandler.fluidInputSize : recipeHandler.fluidOutputSize;
        if (ctIngredients.size() != itemSize + fluidSize) {
            CraftTweakerAPI.logError((String)("A " + recipeHandler.getRecipeName() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        for (i = 0; i < itemSize; ++i) {
            ingredient = CTHelper.buildRemovalItemIngredient(ctIngredients.get(i), recipeHandler);
            if (ingredient == null) {
                this.wasNull = true;
                return;
            }
            itemIngredients.add((IItemIngredient)ingredient);
        }
        for (i = itemSize; i < fluidSize; ++i) {
            ingredient = CTHelper.buildRemovalFluidIngredient(ctIngredients.get(i), recipeHandler);
            if (ingredient == null) {
                this.wasNull = true;
                return;
            }
            fluidIngredients.add((IFluidIngredient)ingredient);
        }
        this.itemIngredients = itemIngredients;
        this.fluidIngredients = fluidIngredients;
        ProcessorRecipe processorRecipe = this.recipe = type == IngredientSorption.INPUT ? (ProcessorRecipe)recipeHandler.getRecipeFromIngredients(itemIngredients, fluidIngredients) : (ProcessorRecipe)recipeHandler.getRecipeFromProducts(itemIngredients, fluidIngredients);
        if (this.recipe == null) {
            this.wasNull = true;
        }
    }

    public void apply() {
        boolean removed;
        if (!this.wasNull && !this.wrongSize && (removed = this.recipeHandler.removeRecipe(this.recipe))) {
            while (removed) {
                this.recipe = this.type == IngredientSorption.INPUT ? (ProcessorRecipe)this.recipeHandler.getRecipeFromIngredients(this.itemIngredients, this.fluidIngredients) : (ProcessorRecipe)this.recipeHandler.getRecipeFromProducts(this.itemIngredients, this.fluidIngredients);
                removed = this.recipeHandler.removeRecipe(this.recipe);
            }
            return;
        }
        RemoveProcessorRecipe.callError();
    }

    public String describe() {
        if (this.wasNull || this.wrongSize) {
            return String.format("Error: Failed to remove %s recipe with %s as the " + (this.type == IngredientSorption.INPUT ? "input" : "output"), this.recipeHandler, RecipeHelper.getAllIngredientNamesConcat(this.itemIngredients, this.fluidIngredients));
        }
        if (this.type == IngredientSorption.INPUT) {
            return String.format("Removing %s recipe: %s", this.recipeHandler, RecipeHelper.getRecipeString(this.recipe));
        }
        return String.format("Removing %s recipes for: %s", this.recipeHandler, RecipeHelper.getAllIngredientNamesConcat(this.itemIngredients, this.fluidIngredients));
    }

    public static void callError() {
        if (!hasErrored) {
            CraftTweakerAPI.logError((String)"At least one NuclearCraft CraftTweaker recipe removal method has errored - check the CraftTweaker log for more details");
        }
        hasErrored = true;
    }
}

