/*
 * Decompiled with CFR 0.152.
 */
package nc.item;

import nc.capability.radiation.resistance.IRadiationResistance;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.item.NCItemMeta;
import nc.util.Lang;
import nc.util.NCUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemRadShielding
extends NCItemMeta<MetaEnums.RadShieldingType> {
    private static final String NOT_HARDCORE = Lang.localise("item.nuclearcraft.rad_shielding.not_hardcore");
    private static final String INSTALL_FAIL = Lang.localise("item.nuclearcraft.rad_shielding.install_fail");
    private static final String INSTALL_SUCCESS = Lang.localise("item.nuclearcraft.rad_shielding.install_success");

    public ItemRadShielding(String nameIn, String[] ... tooltips) {
        super(nameIn, MetaEnums.RadShieldingType.class, tooltips);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!NCConfig.radiation_tile_shielding || !player.func_70093_af()) {
            return this.actionResult(false, stack);
        }
        if (NCConfig.radiation_hardcore_containers <= 0.0) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(NOT_HARDCORE));
            }
            return this.actionResult(false, stack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(world, player, false);
        if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return this.actionResult(false, stack);
        }
        BlockPos pos = raytraceresult.func_178782_a();
        TileEntity te = world.func_175625_s(pos);
        if (!(world.func_175660_a(player, pos) && te != null && te.hasCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null) && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))) {
            return this.actionResult(false, stack);
        }
        IRadiationResistance tile = (IRadiationResistance)te.getCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null);
        if (tile == null) {
            return this.actionResult(false, stack);
        }
        double newResistance = NCConfig.radiation_shielding_level[stack.func_77960_j()];
        NCUtil.getLogger().info((Object)tile.getRadiationResistance());
        if (newResistance <= tile.getRadiationResistance()) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(INSTALL_FAIL + " " + tile.getRadiationResistance()));
            }
            return this.actionResult(false, stack);
        }
        tile.setRadiationResistance(newResistance);
        stack.func_190918_g(1);
        te.func_70296_d();
        if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(INSTALL_SUCCESS + " " + tile.getRadiationResistance()));
        } else {
            player.func_184185_a(SoundEvents.field_187692_g, 0.5f, 1.0f);
        }
        return this.actionResult(true, stack);
    }
}

